<?php
namespace App\Console\Commands;


use App\Models\Auditionee;
use App\Models\AuditioneeParent;
use Illuminate\Console\Command;

class PopulateAuditioneeParents extends Command
{
    protected $signature = 'populate:auditionee-parents';
    protected $description = 'Create parent records and assign to existing auditionees';

    public function handle()
    {
        $this->info('Populating auditionee parents...');

        $auditionees = Auditionee::all()->groupBy('email');

        foreach ($auditionees as $email => $group) {
            $first = $group->first();

            $parent = AuditioneeParent::firstOrCreate(
                ['email' => $email],
                [
                    'firstname' => $first->firstname ?? 'Unknown',
                    'lastname' => $first->lastname ?? 'Unknown',
                ]
            );

            foreach ($group as $auditionee) {
                $auditionee->auditionee_parent_id = $parent->id;
                $auditionee->save();
            }

            $this->info("Assigned parent {$parent->email} to " . count($group) . " auditionees.");
        }

        $this->info('Done.');
    }
}
