<?php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class DisableFortifyOnSubdomain
{
    public function handle(Request $request, Closure $next)
    {
        if (
            str_contains($request->getHost(), 'staging.nymt.smbsolutionsuk.net') || str_contains($request->getHost(), 'rolecall.nymt.org.uk')
        ) {           
            // Redirect Fortify-like routes to  YCM equivalents
            if ($request->path() === 'login') {
                return redirect('/ycm/login');
            }

            if ($request->path() === 'forgot-password') {
                return redirect('/ycm/forgot-password');
            }

            if ($request->is('reset-password/*')) {
                $token = $request->route('token');
                return redirect("/ycm/reset-password/{$token}");
            }
        }

        return $next($request);
    }
}
