<?php

namespace App\Livewire\Auditionee;

use Livewire\Component;
use Livewire\WithPagination;
use App\Mail\CoursePaid;
use App\Models\Auditionee;
use App\Models\Course;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Mail;

class AttendeeList extends Component
{
    use WithPagination;
    
    protected $queryString = ['sortField','sortDirection','view'];
    public $auditionee_id,$course_id, $course;
    

    public $isOpen = 0,  $template = 'list', $inputsearch;
    public $view = 'list',$sortField = 'lastname', $sortDirection = 'asc', $perPage = '20';
    
    
    public function mount(Request $request)
    {
                if ($request->id) {
                    $this->course_id = $request->id;
                    $this->course = Course::find($this->course_id);
                }
        
    }

    public function render()

    {
        
        
        
        $query = Auditionee::where('id','>',0);
        
               // live filter
    	if(strlen($this->inputsearch)>=1){
    	    
    	    $searchResult = $this->inputsearch;
    	    
    		$query->where('firstname','like','%'.$searchResult.'%');
    		$query->orwhere('lastname','like','%'.$searchResult.'%');
    		$query->orwhere('email','like','%'.$searchResult.'%');
    	}
    	
    	
    	// deal with sortby
    	
    	    $query->orderBy($this->sortField,$this->sortDirection);

    	    
    	if($this->course_id >= 1){
    	    $query->whereRelation('courses','course_id','=',$this->course_id);
    	}
    	    
        return view('nymt.auditionee.course-'.$this->view , [
            'myattendees' => $query->paginate($this->perPage),
            ]);

    }
    
    
    public function sortBy($field){
        
        if ($this->sortField === $field) {
            $this->sortDirection = $this->sortDirection ==='asc' ? 'desc' : 'asc';
        } else {
            $this->sortDirection ='asc';
        }
        
        $this->sortField = $field;
    }


    public function create()
    {
        $this->resetInputFields();
        $this->openModal();
    }
    
    
    public function edit($id)
    {
        return redirect()->to('/auditionees/edit/'.$id);
    }
    
    
    public function sendCourse($auditionee_id,$course_id)
    {
        $auditionee = Auditionee::find($auditionee_id);
        if ($auditionee->secondary_email){
            Mail::to($auditionee->email)->cc($auditionee->secondary_email)->send(new CoursePaid($auditionee_id,$course_id));
        } else {
            Mail::to($auditionee->email)->send(new CoursePaid($auditionee_id,$course_id));
        }
        
        session()->flash('message', 'Course Email Successfully sent to '.$auditionee->email.' .');


    }
}
