<?php

namespace App\Livewire\Auditionee;

use Livewire\Component;
use Livewire\WithPagination;
use App\Mail\AuditionPaid;
use App\Models\Auditionee;
use App\Models\VenueDate;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Mail;

class AuditionList extends Component
{
    use WithPagination;
    
    protected $queryString = ['sortField','sortDirection','view'];
    public $auditionee_id,$venue_date_id, $venuedate;
    

    public $isOpen = 0,  $template = 'grid', $inputsearch;
    public $view = 'grid',$sortField = 'lastname', $sortDirection = 'asc', $perPage = '20';
    
    
    public function mount(Request $request)
    {
                if ($request->id) {
                    $this->venue_date_id = $request->id;
                    $this->venuedate = VenueDate::find($this->venue_date_id);
                }
        
    }

    public function render()

    {
        
        $query = Auditionee::where('id','>',0)->where('category','=','actor');
        
    	
    	// deal with sortby
    	
    	    $query->orderBy('dob',$this->sortDirection);

    	    
    	if($this->venue_date_id >= 1){
    	    $query->whereRelation('auditions','venue_date_id','=',$this->venue_date_id);
    	}
    	
    	$numauditions = count($this->venuedate->actorauditions());
    	
    	
    	    $this->perPage = $numauditions;
    	    
  
    	if ($numauditions > 25){
    	    $this->perPage = ceil($numauditions/3);
    	}
    	
    	    
        return view('nymt.auditionee.audition-'.$this->view , [
            'myauditionees' => $query->paginate($this->perPage),
            ]);

    }
    
    
    public function sortBy($field){
        
        if ($this->sortField === $field) {
            $this->sortDirection = $this->sortDirection ==='asc' ? 'desc' : 'asc';
        } else {
            $this->sortDirection ='asc';
        }
        
    $this->sortField = $field;
    }


    public function create()

    {

        $this->resetInputFields();
        $this->openModal();

    }
    
    

    public function edit($id)

    {

        return redirect()->to('/auditionees/audition-notes/'.$id);

    }

    public function delete($id)

    {


        $user = Auditionee::find($id);
        $user->delete();

        session()->flash('message', 'Auditionee Deleted Successfully.');

    }
    
    public function sendAudition($auditionee_id)

    {
        
        $auditionee = Auditionee::find($auditionee_id);
        
        if ($auditionee->secondary_email){
            Mail::to($auditionee->email)->cc($auditionee->secondary_email)->send(new AuditionPaid($auditionee_id));
        } else {
            Mail::to($auditionee->email)->send(new AuditionPaid($auditionee_id));
        }
        
        session()->flash('message', 'Audition Email Successfully sent to '.$auditionee->email.' .');


    }
}
