<?php

namespace App\Livewire\Auditionee\Forms;

use Livewire\Form;
use Livewire\Attributes\Rule;
use App\Models\Audition;

class AuditionForm extends Form
{
    #[Rule('required')]
    public $auditionee_id = '';

    #[Rule('required')]
    public $venue_date_id = '';

    public function save()
    {
        $this->validate();

        Audition::create([
            'venue_date_id' => $this->venue_date_id,
            'auditionee_id' => $this->auditionee_id,
        ]);

        $this->reset(['venue_date_id']);
    }
}