<?php

namespace App\Livewire\Auditionee\Forms;

use Livewire\Form;
use Livewire\Attributes\Rule;
use App\Models\AuditioneeComment;

class CommentForm extends Form
{
    #[Rule('required')]
    public $auditionee_id = '';
    public $commentgroup = '';
    public $commentcategory_id = '';
    public $score = 0;
    public $comment = '';

    public function save()
    {
        $this->validate();

        AuditioneeComment::create([
            'auditionee_id' => $this->auditionee_id,
            'commentgroup' => $this->commentgroup,
            'commentcategory_id' => $this->commentcategory_id,
            'score' => $this->score,
            'comment' => $this->comment,
        ]);

    }
}