<?php

namespace App\Livewire\Auditionee\Forms;

use Livewire\Form;
use Livewire\Attributes\Rule;
use App\Models\AuditioneeRole;


class RoleForm extends Form
{
    #[Rule('required')]
    public $auditionee_id = '';
    
    #[Rule('required')]
    public $role_id = '';
    public $status = 1;
    public $choice = 1;
    
    public function save()
    {
        $this->validate();

        AuditioneeRole::create([
            'auditionee_id' => $this->auditionee_id,
            'role_id' => $this->role_id,
            'choice' => $this->choice,
            'status' => $this->status,
        ]);

    }
}