<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\Auditionee;
use App\Models\Venue;
use App\Models\VenueDate;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Validation\Rule;

class Auditionees extends Component
{
    use WithPagination;
    
    protected $queryString = ['sortField','sortDirection'];
    public $auditionee_id;
    public $venues;
    

    public $isOpen = 0,  $template = 'grid', $inputsearch = '', $venuefilter = '', $categoryfilter = '';
    public $sortField = 'lastname', $sortDirection = 'asc', $perPage = '20';
    
    public function mount(Request $request)
    {

        //$this->inputsearch = session()->get('inputsearch');
              
                
    }

    public function render()

    {
        
        $query = Auditionee::where('id','>',0);
        
        $this->venues = VenueDate::where('id','>',0)->orderBy('name')->get();
        
               // live filter
               
    	if(strlen($this->inputsearch)>=1){
    	    
    	    $searchResult = $this->inputsearch;
    	    
    		$query->where('firstname','like','%'.$searchResult.'%');
    		$query->orwhere('lastname','like','%'.$searchResult.'%');
    		$query->orwhere('email','like','%'.$searchResult.'%');
    		
    	}
    	
    	if(strlen($this->categoryfilter)>=1){
    	    $searchResult = $this->categoryfilter;
    		    $query->where('category','like','%'.$searchResult.'%');
    	}
    	
    	if(strlen($this->venuefilter)>=1){
    	    $searchResult = $this->venuefilter;
    		    $query->whereHas('audition', function($q){
    		          
    		            $q->where('venue_date_id','=', $this->venuefilter);
    		            //$q->whereHas('venue_date', function($sq){
                        //    $sq->where('venue_id', '=', $this->venuefilter);
                        //});
                });
    	}
    	
    	
    	// deal with sortby
    	
    	    $query->orderBy($this->sortField,$this->sortDirection);

    	    

        return view('nymt.auditionees', [
            'myauditionees' => $query->paginate($this->perPage),
            ]);

    }
    
    
    public function sortBy($field){
        
        if ($this->sortField === $field) {
            $this->sortDirection = $this->sortDirection ==='asc' ? 'desc' : 'asc';
        } else {
            $this->sortDirection ='asc';
        }
        
    $this->sortField = $field;
    }


    public function create()

    {

        $this->resetInputFields();
        $this->openModal();

    }


    public function edit($id)

    {
        return redirect()->to('/auditionees/edit/'.$id);

    }

    public function delete($id)

    {


        $user = Auditionee::find($id);
        $user->delete();

        session()->flash('message', 'Auditionee Deleted Successfully.');

    }
}
