<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\CommentCategory;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Validation\Rule;

class CommentCategories extends Component
{
    use WithPagination;
    
    public $comment_category_id;
    public $name,$rank,$type;
    
    public $isOpen = 0,  $inputsearch;
    public $perPage = '20';
    
    public function render()

    {
        
        $query = CommentCategory::where('id','>',0);
        
               // live filter
    	if(strlen($this->inputsearch)>=1){
    	    
    	    $searchResult = $this->inputsearch;
    	    
    		$query->where('name','like','%'.$searchResult.'%');
    		$query->orwhere('type','like','%'.$searchResult.'%');
    	}
    	
    	    $query->orderBy('type')->orderBy('rank');


        return view('nymt.commentcategories', [
            'mycategories' => $query->paginate($this->perPage),
            ]);
    }
    
       public function create()
    {
        $this->resetInputFields();
        $this->openModal();

    }

  

    public function openModal()
    {
        $this->isOpen = true;
    }

    public function closeModal()
    {
        $this->isOpen = false;
    }

    private function resetInputFields(){
        $this->name = '';
        $this->type = '';
        $this->rank = '';
        $this->comment_category_id = null;
    }

     

    public function store()

    {

        $this->validate([
            'name' => 'required',
            'type' => 'required',
            'rank' => 'required',
        ]);

        CommentCategory::updateOrCreate(['id' => $this->comment_category_id], [

            'name' => $this->name,
            'type' => $this->type,
            'rank' => $this->rank

        ]);

 
        session()->flash('message', 

        $this->comment_category_id ? 'Category Updated Successfully.' : 'Category Created Successfully.');


        $this->closeModal();

        $this->resetInputFields();

    }

    public function edit($id)

    {
        $category = CommentCategory::findOrFail($id);
        $this->comment_category_id = $id;
        $this->name = $category->name;
        $this->type = $category->type;
        $this->rank = $category->rank;
        $this->openModal();

    }
    

    public function delete($id)

    {
        $user = CommentCategory::find($id);
        $user->delete();
        session()->flash('message', 'Category Deleted Successfully.');

    }
}