<?php

namespace App\Livewire\Component;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\Course;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Validation\Rule;

class CourseDash extends Component
{
    use WithPagination;
    

    public function render()
    {
        
        
        $today = date('y-m-d');
        
        $query = Course::where('id','>',0);
        
    	
    	$query->where('start_date','>=',$today);
    	$query->orderBy('start_date','asc');

        return view('nymt.dashboard.courses', [
            'mycourses' => $query->limit(5)->get(),
            ]);

    }
    
    
    
    public function course($id){
        
        return redirect()->to('/auditionees/attendee-list/'.$id.'?view=list');
    }


}