<?php

namespace App\Livewire\Component;

use Livewire\Component;


class EditField extends Component
{
    public $origValue,$object,$operation_id,$isValue,$newValue,$field,$input; 
    
    public function mount($id,$object,$field,$input = 'text')
    {
        switch ($object){
        case 'Course':
        $this->object = \App\Models\Course::findOrFail($id);
        break;
        case 'Venue':
        $this->object = \App\Models\Venue::findOrFail($id);
        break;
        case 'VenueDate':
        $this->object = \App\Models\VenueDate::findOrFail($id);
        break;
        case 'Project':
        $this->object = \App\Models\Project::findOrFail($id);
        break;
        case 'Role':
        $this->object = \App\Models\Role::findOrFail($id);
        break;
        case 'Auditionee':
        $this->object = \App\Models\Auditionee::findOrFail($id);
        break;
        case 'AuditioneePastoral':
        $this->object = \App\Models\AuditioneePastoral::findOrFail($id);
        break;
        case 'AuditioneeComment':
        $this->object = \App\Models\AuditioneeComment::findOrFail($id);
        break;
        case 'CommentCategory':
        $this->object = \App\Models\CommentCategory::findOrFail($id);
        break;
        case 'AuditionScore':
        $this->object = \App\Models\AuditionScore::firstOrCreate(
            ['audition_id' =>  $id],
            [
                'audition_id' =>  $id
            
            ]);
        break;
        }
        $this->origValue = $this->object->$field;
        $this->field = $field;
        $this->input = $input;
    }

    public function render()
    {
        
        $this->newValue = $this->origValue;
        return view('components.nymt.components.edit-field');
    }
    
    
    public function save($field,$value = false,$isint = false) // this fails when value =''
    {
        $valid = true;
        if (empty($value)) { $value = $this->newValue; }
        if (empty($value)) { $value = null; }
        if ($isint){
            $valid = is_int($value);
        }
        if ($valid){
            $this->object->$field = $value;
            $this->object->save();
            $this->origValue = $value;
            session()->flash('message', $field.' Edited Successfully.');
        }
    }
    public function saveAlpine($field,$value,$isint = false)
    {
        $valid = true;

        if ($isint){
            $valid = is_int($value);
        }
        if ($valid){
            $this->object->$field = $value;
            $this->object->save();
            $this->origValue = $value;
            session()->flash('message', $field.' Edited Successfully.');
        }
    }

}