<?php

namespace App\Livewire\Course\Forms;

use Livewire\Form;
use Livewire\WithFileUploads;
use Livewire\Attributes\Validate;
use Illuminate\Validation\Rule;
use Illuminate\Support\Str;
use App\Models\Course;

class MainForm extends Form
{
    use WithFileUploads;
    
    public Course $course;
    #[Validate('required|min:3', onUpdate: false)]
    public $name= ''; 
    public $start_date = '';
    public $end_date =  '';
    public $capacity = 0;
    public $price = 0;
    public $location = '';
    public $residential = 0;
    public $description ='';
    public $email_text ='';
    
    public $course_id = false;
    
    

    public function setCourse($id)
    {
        
        $this->course = Course::find($id);
        
        if ($this->course){
            
        $this->course_id = $this->course->id;
        $this->name = $this->course->name;
        $this->description = $this->course->description;
        $this->email_text = $this->course->email_text;
        $this->start_date = date('Y-m-d' , strtotime($this->course->start_date));
        $this->end_date = date('Y-m-d' , strtotime($this->course->end_date));
        $this->capacity = $this->course->capacity;
        $this->price = $this->course->price;
        $this->location = $this->course->location;
        $this->residential = $this->course->residential;
        
        } 

    }
    

    public function update()
    {
        $this->validate();
        
        Course::updateOrCreate(['id' => $this->course_id], [
            'name' => $this->name,
            'description' => $this->description,
            'email_text' => $this->email_text,
            'start_date' => date('Y-m-d H:i:s' , strtotime($this->start_date)),
            'end_date' => date('Y-m-d H:i:s' , strtotime($this->end_date)),
            'capacity' => $this->capacity,
            'price' => $this->price,
            'location' => $this->location,
            'residential' => $this->residential
        ]);
        
    }
}