<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\Course;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Validation\Rule;

class Courses extends Component
{
    use WithPagination;
    
    protected $queryString = ['sortField','sortDirection'];
    public $venue_id;
    
    public $isOpen = 0,  $template = 'grid', $inputsearch;
    public $sortField = 'start_date', $sortDirection = 'desc', $perPage = '20';
    

    public function render()
    {
        
        $query = Course::where('id','>',0);
        
               // live filter
    	if(strlen($this->inputsearch)>=1){
    	    
    	    $searchResult = $this->inputsearch;
    	    
    		$query->where('name','like','%'.$searchResult.'%');
    	}
    	
    	// deal with sortby
    	
    	$query->orderBy($this->sortField,$this->sortDirection);


        return view('nymt.courses', [
            'mycourses' => $query->paginate($this->perPage),
            ]);

    }
    
    
    public function sortBy($field){
        
        if ($this->sortField === $field) {
            $this->sortDirection = $this->sortDirection ==='asc' ? 'desc' : 'asc';
        } else {
            $this->sortDirection ='asc';
        }
        
    $this->sortField = $field;
    }
    
    public function courselist($id){
        
        return redirect()->to('/auditionees/attendees-list/'.$id);
    }


    public function edit($id)

    {
        return redirect()->to('/courses/edit/'.$id);
    }

    public function delete($id)

    {
        $user = Course::find($id);
        $user->delete();

        session()->flash('message', 'Course Deleted Successfully.');
    }
    
    
    public function course($id){
        
        return redirect()->to('/auditionees/attendee-list/'.$id.'?view=list');
    }

}