<?php

namespace App\Livewire\Frontend;


use App\Models\Auditionee;
use App\Models\Attendee;
use App\Models\Course;
use App\Livewire\Frontend\Forms\CourseForm;
use Livewire\Component;
use Livewire\Attributes\Validate;
use Livewire\WithFileUploads;
use Illuminate\Validation\Rule;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class CourseRegistration extends Component
{
    
    use WithFileUploads;
    public CourseForm $form;
    public Course $course;

    public $crud, $chosenvenue = false;
    public $courses, $course_id;
    public $showAddPostDialog = false;
    public $showAddCommentDialog = false;
    
    
    public $hideForm = false;
    
    public $steps = array(
        1 => false,
        2 => false,
        3 => false,
        4 => false,
        5 => false,
        6 => false,
        7 => false
        );


    public function render()
    {
        $this->crud = 'Course Application';
        $query = Course::where('id','>',0);
        
        $today = date('y-m-d');
    	$query->where('start_date','>=',$today);
    	$query->orderBy('start_date','asc');
        $this->courses = $query->limit(20)->get();
        
        if ($this->course_id > 0) {
            $this->course = Course::find($this->course_id);
        }
        
        
        return view('frontend.course-application')
            ->layout('layouts.frontend-ycm');
    }

    
    public function save()
    {
        $this->form->update();

        sleep(1);
        
        if ($this->course_id){
            $attendee = Attendee::firstOrCreate([
                'course_id' => $this->course_id,
                'auditionee_id' => $this->form->auditionee_id
            ]);
            if ($attendee->wasRecentlyCreated === false) {
                // It already existed
                if ($attendee->auditionee_transaction_id && $attendee->transaction?->status === 'success') {
                        session()->flash('message', 'You have already paid for this course!!!');
                        return redirect()->back();
                } 
            }
        }

        redirect()->to('/payCourse/'.$this->form->auditionee_id.'/'.$this->course_id);
    }
    
    
    public function validateStep($step){
        
        
        if (isset($this->steps[$step])){
    
            switch($step){
                case 1:
                        $this->steps[$step] = true;      
                        $this->dispatch('livewire-step-validated', tab: 'tab-1-2');
    
                break;
                case 2:
                    if ($this->form->email && $this->form->gender && $this->form->dob && $this->form->lastname && $this->form->firstname){
                        $this->steps[$step] = true;      
                        $this->dispatch('livewire-step-validated', tab: 'tab-1-3');
                    } else {
                        $this->steps[$step] = false;
                        session()->flash('message', 'Please fill out all your information');
                    }
    
                break;
                case 3:
                    if ($this->form->address && $this->form->town && $this->form->postcode && $this->form->country && $this->form->photo){
                        $this->steps[$step] = true;      
                        $this->dispatch('livewire-step-validated', tab: 'tab-1-4');
                    } else {
                        $this->steps[$step] = false;
                        session()->flash('message', 'Please fill out all your address information');
                    }
                break;
                case 4:
                    if ($this->form->ageAtDate($this->course->end_date) > 17) {
                        if ($this->form->language_disclaimer > 0 && $this->form->casting_fee > 0 && (count($this->form->children) == 4)){
                            $this->steps[$step] = true;      
                            $this->dispatch('livewire-step-validated', tab: 'tab-1-5');
                        } else {
                            $this->steps[$step] = false;
                            session()->flash('message', 'Please check all the boxes');
                        }
                    } else {
                        if ($this->course->residential >0) {
                            if ($this->form->residential > 0 && $this->form->language_disclaimer > 0 && $this->form->casting_fee > 0){
                                $this->steps[$step] = true;      
                                $this->dispatch('livewire-step-validated', tab: 'tab-1-5');
                            } else {
                                $this->steps[$step] = false;
                                session()->flash('message', 'Please check all the boxes');
                            }
                        } else {
                            if ($this->form->language_disclaimer > 0 && $this->form->casting_fee > 0){
                                $this->steps[$step] = true;      
                                $this->dispatch('livewire-step-validated', tab: 'tab-1-5');
                            } else {
                                $this->steps[$step] = false;
                                session()->flash('message', 'Please check all the boxes');
                            }
                        }
                    }
                break;
                case 5:
                    if ($this->form->emergency_2_contact && $this->form->emergency_2_relationship  && $this->form->emergency_2_tel){
                        $this->steps[$step] = true;      
                        $this->dispatch('livewire-step-validated', tab: 'tab-1-6');
                    } else {
                        $this->steps[$step] = false;
                        session()->flash('message', 'Please fill out all your Second Emergency Contact Information');
                    }
                break;
                case 6:
                        $this->steps[$step] = true;      
                        $this->dispatch('livewire-step-validated', tab: 'tab-1-7');
                break;
                case 7:
                    if ($this->form->consent && $this->form->birth_gender){
                        $this->steps[$step] = true;      
                        $this->dispatch('livewire-step-validated', tab: 'tab-1-8');
                    } else {
                        $this->steps[$step] = false;
                        session()->flash('message', 'Please fill out all required fields');
                    }
                break;
                
            }
            
        } 
    }
    
}