<?php

namespace App\Livewire\Frontend\Forms;

use Livewire\Form;
use Livewire\WithFileUploads;
use Livewire\Attributes\Validate;
use Illuminate\Support\Str;
use App\Models\Auditionee;
use App\Models\AuditioneePastoral;
use App\Enums\Country;
use Carbon\Carbon;

class UserForm extends Form
{
    use WithFileUploads;
    
    public Auditionee $auditionee;
    public AuditioneePastoral $pastoral;
    #[Validate('required', message: 'Please enter the name you would like to be known by')]
    public $firstname= ''; 
    #[Validate('required', message: 'Please enter your family name')]
    public $lastname = '';
    public $formalname = '';    
    #[Validate('unique:auditionees', message: 'This email has already been taken. If you\'re registering multiple children, please enter a different email address as the main contact email, and then your original email address below under "Secondary Contact Email". If you have already completed a form but have not yet paid, please email us at enquiries@nymt.org.uk to make payment.')]
    #[Validate('email', message: 'Please enter your Email')]
    public $email = '';
    #[Validate('email', message: 'Please enter your Email')]
    public $secondary_email = '';
    #[Validate('required', message: 'Please enter your Date of Birth!')]
    public $dob = '';
    #[Validate('required')]
    public $address = '';
    #[Validate('required')]
    public $town = '';
    #[Validate('required')]
    public $postcode = '';
    public $tel = '';
    #[Validate('required')]
    public $emergency_contact = '';
    #[Validate('required')]
    public $emergency_relationship = '';
    #[Validate('required')]
    public $emergency_tel = '';
    public $ethnicity = '';
    #[Validate('required', message: 'Please choose one - prefer not to say is absolutely fine!')]
    public $gender = '';
    public $category = '';
    public $dancing_experience = [];
    public $singing_experience = '';
    public $acting_experience = '';
    public $profile_photo_path = '';
    public $profile_video_path = '';
    public $auditionee_id = false;
    public $password = '';
    public $licensed = 0;
    public $license_info = '';
    //pastoral
    public $pastoral_id = false;
    public $pastoral_allergies = '';
    public $pastoral_epipen = 0;
    public $pastoral_inhaler = 0;
    public $pastoral_comment = ''; 
    public $pastoral_barriers = '';
    public $pastoral_disability = '';
    
    
    #[Validate('image|mimes:jpeg,jpg,png|max:4096', message: 'Photos must be smaller than 4mb')] // 4MB Max
    public $photo;
    
    #[Validate('required')]
    public Country $country;
    
    #[Validate('required')]
    public $marketing_emails = false;
    public $marketing_terms = '';
    public $education = '';
    public $education_type = '';
    public $film_permission = '';
    public $film_permission_other = '';
    public $unavailability = '';
    public $nymt_experience = '';
    public $nymt_experience_no = '';
    public $nymt_experience_yes = '';
    public $nymt_experience_no_other = '';
    public $nymt_role = false;
    public $dance_skill_level = '';
    public $musical_instruments = '';
    public $special_skills= '';
    
    
    public function setUser($id)
    {
        
        $auditionee = Auditionee::find($id);
        
        if ($auditionee){
        $this->auditionee = $auditionee;

        $this->auditionee_id = $auditionee->id;
        $this->firstname = $this->auditionee->firstname;
        $this->lastname = $this->auditionee->lastname;
        $this->formalname = $this->auditionee->formalname;
        $this->email = $this->auditionee->email;
        $this->secondary_email = $this->auditionee->secondary_email;
        $this->dob = date('Y-m-d', strtotime($this->auditionee->dob));
        $this->address = $this->auditionee->address;
        $this->town = $this->auditionee->town;
        $this->postcode = $this->auditionee->postcode;
        $this->country = $this->auditionee->country;
        $this->tel = $this->auditionee->tel;
        $this->emergency_contact = $this->auditionee->emergency_contact;
        $this->emergency_relationship = $this->auditionee->emergency_relationship;
        $this->emergency_tel = $this->auditionee->emergency_tel;
        $this->ethnicity = $this->auditionee->ethnicity;
        $this->gender = $this->auditionee->gender;
        $this->category = $this->auditionee->category;
        $this->dancing_experience =  $this->auditionee->dancing_experience ? json_decode($this->auditionee->dancing_experience) : [];
        $this->singing_experience = $this->auditionee->singing_experience;
        $this->acting_experience = $this->auditionee->acting_experience;
        $this->profile_photo_path = $this->auditionee->profile_photo_path;
        $this->profile_video_path = $this->auditionee->profile_video_path;
        $this->licensed = $this->auditionee->licensed;
        $this->license_info = $this->auditionee->license_info;
        $this->password = $this->auditionee->password;
        $this->marketing_emails = $this->auditionee->marketing_emails;
        $this->marketing_terms = $this->auditionee->marketing_terms;
        $this->education = $this->auditionee->education;
        $this->education_type = $this->auditionee->education_type;
        $this->film_permission = $this->auditionee->film_permission;
        $this->film_permission_other = $this->auditionee->film_permission_other;
        $this->unavailability = $this->auditionee->unavailability;
        $this->nymt_experience = $this->auditionee->nymt_experience;
        $this->nymt_experience_no = $this->auditionee->nymt_experience_no;
        $this->nymt_experience_yes = $this->auditionee->nymt_experience_yes;
        $this->nymt_experience_no_other = $this->auditionee->nymt_experience_no_other;
        $this->nymt_role = $this->auditionee->nymt_role;
        $this->dance_skill_level = $this->auditionee->dance_skill_level;
        $this->musical_instruments = $this->auditionee->musical_instruments;
        $this->special_skills = $this->auditionee->special_skills;
        
        if ($auditionee->pastoral){
            $this->pastoral = AuditioneePastoral::find($auditionee->pastoral->id);
            $this->pastoral_id = $this->pastoral->id;
            $this->pastoral_allergies = $this->pastoral->allergies;
            $this->pastoral_epipen = $this->pastoral->epipen;
            $this->pastoral_inhaler = $this->pastoral->inhaler;
            $this->pastoral_comment = $this->pastoral->comment;
            $this->pastoral_barriers = $this->pastoral->barriers;
            $this->pastoral_disability = $this->pastoral->disability;
        }
        
        
        
        } 

    }

    public function update()
    {
        $this->validate();
        
        if ($this->photo){
        $fileName = Str::slug(strip_tags($this->photo->getClientOriginalName()), '-');
        
        $extension = $this->photo->extension();
        
        $prefix ="";
        if ($this->auditionee_id && $this->auditionee_id > 0){
            $prefix = $this->auditionee_id;
        } else {
            $prefix = Carbon::now()->timestamp;;
        }
        
        $fileName = $prefix."_".str_replace($extension, '',$fileName).".".$extension;
        $this->profile_photo_path = $fileName;
        $this->photo->storeAs('public/auditionee', $fileName);
        }

        $this->auditionee = Auditionee::updateOrCreate(['id' => $this->auditionee_id], [
            'firstname' => $this->firstname,
            'lastname' => $this->lastname,
            'formalname' => $this->formalname,
            'email' => $this->email,
            'secondary_email' => $this->secondary_email,
            'dob' => date('Y-m-d H:i:s' , strtotime($this->dob)),
            'address' => $this->address,
            'town' => $this->town,
            'postcode' => $this->postcode,
            'country' => $this->country,
            'tel' => $this->tel,
            'emergency_contact' => $this->emergency_contact,
            'emergency_relationship' => $this->emergency_relationship,
            'emergency_tel' => $this->emergency_tel,
            'ethnicity' => $this->ethnicity,
            'gender' => $this->gender,
            'category' => $this->category,
            'dancing_experience' => json_encode($this->dancing_experience),
            'singing_experience' => $this->singing_experience,
            'acting_experience' => $this->acting_experience,
            'marketing_emails' => $this->marketing_emails,
            'marketing_terms' => $this->marketing_terms,
            'education' => $this->education,
            'education_type' => $this->education_type,
            'film_permission' => $this->film_permission,
            'film_permission_other' => $this->film_permission_other,
            'unavailability' => $this->unavailability,
            'nymt_experience' => $this->nymt_experience,
            'nymt_experience_no' => $this->nymt_experience_no,
            'nymt_experience_yes' => $this->nymt_experience_yes,
            'nymt_experience_no_other' => $this->nymt_experience_no_other,
            'nymt_role' => $this->nymt_role,
            'dance_skill_level' => $this->dance_skill_level,
            'musical_instruments' => $this->musical_instruments,
            'special_skills' => $this->special_skills,
            'profile_photo_path' => $this->profile_photo_path,
            'profile_video_path' => $this->profile_video_path,
            'licensed' => $this->licensed,
            'license_info' => $this->license_info,
            'password' => $this->password,
        ]);
        $this->auditionee_id = $this->auditionee->id;
        $this->pastoral = AuditioneePastoral::updateOrCreate(['id' => $this->pastoral_id], [
            'allergies' => $this->pastoral_allergies,
            'epipen' => $this->pastoral_epipen,
            'inhaler' => $this->pastoral_inhaler,
            'barriers' => $this->pastoral_barriers,
            'disability' => $this->pastoral_disability,
            'comment' => $this->pastoral_comment,
            'auditionee_id' => $this->auditionee_id,
        ]);
        $this->pastoral_id = $this->pastoral->id;
        
    }
}