<?php

namespace App\Livewire\Frontend;

use App\Models\Auditionee;
use Livewire\Component;
use Srmklive\PayPal\Services\PayPal as PayPalClient;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\URL;

class PayController extends Component
{
    public Auditionee $ycm;
    
    public function mount(Request $request)
    {
                if ($request->id) {
                    $request->session()->put('auditioneeId', $request->id);
                }
                
                $auditioneeId = $request->session()->get('auditioneeId');

                $this->ycm = Auditionee::find($auditioneeId);
    }
    
    
    public function render()
    {
        return view('frontend.pay')
            ->layout('layouts.frontend-ycm');
    }
    
    /**
     * Write code on Method
     *
     * @return response()
     */

    public function index(Request $request)

    {
        if ($request->id) {
            $request->session()->put('auditioneeId', $request->id);
        }
        
        
        return view('frontend.pay')
            ->layout('layouts.frontend-ycm');
    }
    
    
    public function viewdetails(Request $request){
            $detailsUrl = URL::signedRoute('auditionee.details', [
            'id' => $request->session()->get('auditioneeId'),
            ]);
            
            return redirect($detailsUrl);
    
    }

  

    /**
     * Write code on Method
     *
     * @return response()
     */

    public function payment(Request $request)

    {
        
        
        $auditioneeId = $request->session()->get('auditioneeId');

        $auditionee = Auditionee::find($auditioneeId);
        
        if (!$auditionee){
            
            return redirect()
                ->route('cancel.payment')
                ->with('error', 'No Auditionee Please start again.');
            
        }
        
        $reference_id = $auditionee->id;
        
        
        switch ($auditionee->category){
            case 'musician':
            $fee =  25.00;
            $venue_date_id = "AUDITION-".$auditionee->audition->venue_date->id;
            break;
            case 'actor':
            $fee =  45.00;
            $venue_date_id = "AUDITION-".$auditionee->audition->venue_date->id;
            break;
            case 'cpp':
            $fee =  25.00;
            $venue_date_id = "CPP";
            break;
            default:
            $fee =  false;
            break;
        }
        
        if (!$fee){
            
            return "No fee for this category type";
            
        }
        
        
        $reference_id =  "NYMT-".$venue_date_id."-".$auditionee->category."-".$auditionee->id;
        
        $provider = new PayPalClient;
        $provider->setApiCredentials(config('paypal'));
        $paypalToken = $provider->getAccessToken();

        $response = $provider->createOrder([

            "intent" => "CAPTURE",

            "application_context" => [
                "return_url" => route('paypal.payment.success'),
                "cancel_url" => route('paypal.payment.cancel'),
            ],

            "purchase_units" => [

                0 => [
                    "custom_id" => $auditionee->id,
                    "reference_id" => $reference_id,
                    "amount" => [
                        "currency_code" => "GBP",
                        "value" => $fee

                    ]
                ]
            ]
        ]);

  

        if (isset($response['id']) && $response['id'] != null) {

            foreach ($response['links'] as $links) {

                if ($links['rel'] == 'approve') {
                    return redirect()->away($links['href']);
                }
            }

            return redirect()
                ->route('paypal', ['id' => $request->session()->get('auditioneeId')])
                ->with('error', 'Something went wrong.');

        } else {

            return redirect()
                ->route('paypal', ['id' => $request->session()->get('auditioneeId')])
                ->with('error', $response['message'] ?? 'Something went wrong.'.$auditionee->category);

        }
    }

  

    /**
     * Write code on Method
     *
     * @return response()
     */

    public function paymentCancel(Request $request)

    {

        return redirect()
              ->route('paypal', ['id' => $request->session()->get('auditioneeId')])
              ->with('error', $response['message'] ?? 'You have canceled the transaction.');
    }

    /**
     * Write code on Method
     *
     * @return response()
     */

    public function paymentSuccess(Request $request)

    {

        $provider = new PayPalClient;
        $provider->setApiCredentials(config('paypal'));
        $provider->getAccessToken();
        $response = $provider->capturePaymentOrder($request['token']);


        if (isset($response['status']) && $response['status'] == 'COMPLETED') {

            return redirect()
                ->route('paypal', ['id' => $request->session()->get('auditioneeId')])
                ->with('success', 'Transaction complete.');

        } else {

            return redirect()
                ->route('paypal', ['id' => $request->session()->get('auditioneeId')])
                ->with('error', $response['message'] ?? 'Something went wrong.');

        }

    }

}