<?php

namespace App\Livewire\Frontend;


use App\Models\Auditionee;
use App\Models\AuditioneeComment;
use App\Models\Audition;
use App\Models\CommentCategory;
use App\Models\Project;
use App\Models\Venue;
use App\Models\VenueDate;
use App\Livewire\Frontend\Forms\UserForm;
use Livewire\Component;
use Livewire\Attributes\Validate;
use Livewire\WithFileUploads;
use Illuminate\Validation\Rule;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class Register extends Component
{
    
    use WithFileUploads;
    public UserForm $form;
    public $venuedate;

    public $crud, $chosenvenue = false;
    public $venues,$projects,$venuedates,$commentcategories;
    public $showAddPostDialog = false;
    public $showAddCommentDialog = false;
    
    public $emailsMatchError = false;
    
    public $hideForm = false;
    
    public $steps = array(
        1 => false,
        2 => false,
        3 => false,
        4 => false,
        5 => false,
        6 => false,
        7 => false,
        8 => false,
        9 => false,
        10 => false
        );

    public function mount(Request $request)
    {
                if ($request->applicationType) {
                    $this->form->category = $request->applicationType;
                }
                if ($request->venue) {
                    if ($request->venue >0){
                    $this->venuedate = VenueDate::find($request->venue);
                    } else {
                    $this->venuedate = false; 
                    }
                }
                if ($request->email) {
                    $this->form->email = urldecode($request->email);
                }
                $hashed_random_password = Hash::make(Str::random(6));
                    $this->form->password = 'NYMT'.$hashed_random_password; 
        
    }

    public function render()
    {
            $this->crud = 'empty';
        
        switch ($this->form->category){
            case 'actor':
            $this->crud = "Audition: ".date('l jS F', strtotime($this->venuedate->start_date))." | ".$this->venuedate->venue->town;
            break;
            case 'stage_manager':
            $this->crud = 'Actor';
            break;
            case 'musician':
            $this->crud = 'Musician';
            break;
            case 'cpp':
            $this->crud = 'Creative & Production Pathway';
            break;
        }
        
        
        return view('frontend.register')
            ->layout('layouts.frontend-ycm');
    }
    
    public function updatedFormEmail()
    {
        $this->checkEmails();
    }

    public function updatedFormSecondaryEmail()
    {
        $this->checkEmails();
    }

    private function checkEmails()
    {
        if (!empty($this->form->email) && $this->form->email === $this->form->secondary_email) {
            $this->emailsMatchError = true;
        } else {
            $this->emailsMatchError = false;
        }
    }

    public function openModal()
    {
        $this->showModal = true;
    }
    public function save()
    {
        $this->form->update();

        sleep(1);
        
        if ($this->venuedate){
            $audition = Audition::firstOrCreate([
                'venue_date_id' => $this->venuedate->id,
                'auditionee_id' => $this->form->auditionee_id,
            ]);
            if ($audition->wasRecentlyCreated === false) {
                // It already existed
                if ($audition->auditionee_transaction_id && $audition->transaction?->status === 'success') {
                        session()->flash('message', 'You already paid for this audition!!!!');
                        return redirect()->back();
                } 
            }
        }
        

        session()->flash('message', 'Auditionee Successfully Created.');
        redirect()->to('/pay/'.$this->form->auditionee_id);
    }
    
    public function validateStep($step){
        
        
        if (isset($this->steps[$step])){
    
            switch($step){
                case 1:
                    if ($this->form->email && $this->form->gender && $this->form->dob && $this->form->lastname && $this->form->firstname){
                        
                        if (!empty($this->form->email) && $this->form->email === $this->form->secondary_email) {
                            $this->emailsMatchError = true;
                            $this->steps[$step] = false;
                            session()->flash('message', 'Both Emails cannot be the same.');
                            session()->flash('alert-class', 'bg-red-100'); 
                        } else {
                            $this->steps[$step] = true;      
                            $this->dispatch('livewire-step-validated', tab: 'tab-1-2');
                        }
                    } else {
                        $this->steps[$step] = false;
                        session()->flash('message', 'Please check that you have filled out all the required information.');
                        session()->flash('alert-class', 'bg-red-100'); 
                    }
                    
                break;
                case 2:
                    
                    if ($this->form->address && $this->form->town && $this->form->postcode && $this->form->country && $this->form->photo){
                        $this->steps[$step] = true;      
                        $this->dispatch('livewire-step-validated', tab: 'tab-1-3');
                    } else {
                        $this->steps[$step] = false;
                        session()->flash('message', 'Please check that you have filled out all the required information.');
                        session()->flash('alert-class', 'bg-red-100'); 
                    }
                break;
                case 3:
                    if ($this->form->emergency_contact && $this->form->emergency_relationship && $this->form->emergency_tel){
                        $this->steps[$step] = true;      
                        $this->dispatch('livewire-step-validated', tab: 'tab-1-4');
                    } else {
                        $this->steps[$step] = false;
                        session()->flash('message', 'Please check that you have filled out all the required information.');
                        session()->flash('alert-class', 'bg-red-100'); 
                    }
                break;
                case 4:
                    if ($this->form->category == "actor"){
                        if ($this->form->singing_experience){
                            $this->steps[$step] = true;      
                            $this->dispatch('livewire-step-validated', tab: 'tab-1-5');
                        } else {
                            $this->steps[$step] = false;
                            session()->flash('message', 'Please check that you have filled out: Which voice part best describes your range?');
                            session()->flash('alert-class', 'bg-red-100'); 
                        }
                    } elseif  ($this->form->category == "musician"){
                            $this->steps[$step] = true;      
                            $this->dispatch('livewire-step-validated', tab: 'tab-1-5');
                    } else {
                        if ($this->form->nymt_role && $this->form->acting_experience){
                            $this->steps[$step] = true;      
                            $this->dispatch('livewire-step-validated', tab: 'tab-1-5');
                        } else {
                            $this->steps[$step] = false;
                            session()->flash('message', 'Please check that you have chosen a role and filled out your experience.');
                            session()->flash('alert-class', 'bg-red-100'); 
                        }
                    }
                break;
                case 5:
                        $this->steps[$step] = true;      
                        $this->dispatch('livewire-step-validated', tab: 'tab-1-6');
                break;
                case 6:
                        $this->steps[$step] = true;      
                        $this->dispatch('livewire-step-validated', tab: 'tab-1-7');
                break;
                case 7:
                        $this->steps[$step] = true;      
                        $this->dispatch('livewire-step-validated', tab: 'tab-1-8');
                break;
                case 8:
                    if ($this->form->film_permission){
                        $this->steps[$step] = true;      
                        $this->dispatch('livewire-step-validated', tab: 'tab-1-9');
                    } else {
                        $this->steps[$step] = false;
                        session()->flash('message', 'Please make a choice');
                        session()->flash('alert-class', 'bg-red-100'); 
                    }
                break;
                case 9:
                        $this->steps[$step] = true;      
                        $this->dispatch('livewire-step-validated', tab: 'tab-1-10');
                break;
                case 10:
                        $this->steps[$step] = true;      
                        $this->dispatch('livewire-step-validated', tab: 'tab-1-11');
                break;
                
            }
            
        } 
    }
    
    
    
}