<?php

namespace App\Livewire\Frontend;


use App\Mail\RoleAccepted;
use App\Mail\RoleDeclined;
use App\Models\Auditionee;
use App\Models\AuditioneeRole;
use App\Models\Project;
use App\Livewire\Frontend\Forms\AttendeeForm;
use Livewire\Component;
use Livewire\Attributes\Validate;
use Livewire\WithFileUploads;
use Illuminate\Validation\Rule;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Mail;

class RoleAcceptanceYcm extends Component
{
    
    use WithFileUploads;
    public AttendeeForm $form;
    public $project;

    public $crud;
    public $castrole;
    public $hideForm = false;
    public $formStatus = "Pending";
    public $offerStatus = 1;
    public $roleId = '';
    public $steps = array(
        2 => false,
        3 => false,
        4 => false,
        5 => false,
        6 => false
        );

    public function mount(Request $request)
    {
                if ($request->id) {
                    $this->form->setUser($request->id);
                    $this->project = Project::find($request->projectid);
                } else {
                    exit;
                }
    }

    public function render()
    {
        $this->crud = 'Role Acceptance';


            $roles = $this->form->auditionee->roles;
            if ($roles) {
                foreach ($roles as $role){
                    if ($role->role->project_id == $this->project->id) { // can they have more than one role in same project?
                        $this->castrole = $role->role->name;
                        $this->offerStatus = $role->status;
                        $this->roleId  = $role->id;
                    }
                }
            } 
        
        switch ($this->offerStatus) {
            case 0:
                $this->formStatus = "Declined";
                $this->hideForm = true;
            break;
            case 2:
                $this->formStatus = "Accepted";
                $this->hideForm = true;
            break;
            default:
                $this->formStatus = "Offered";
                $this->hideForm = false;
            break;
                
            
        }
        
        return view('frontend.role-acceptance-ycm')
            ->layout('layouts.frontend-ycm');
    }
    
    
    public function validateStep($step){
        
        
        if (isset($this->steps[$step])){
    
            switch($step){
                case 2:
                    if ($this->form->auditionee->ageAtDate($this->project->end_date) > 17) {
                        if ($this->form->language_disclaimer > 0 && $this->form->casting_fee > 0 && (count($this->form->children) == 4)){
                            $this->steps[$step] = true;      
                            $this->dispatch('livewire-step-validated', tab: 'tab-1-3');
                        } else {
                            $this->steps[$step] = false;
                            session()->flash('message', 'Please Check all the boxes');
                        }
                    } else {
                        if ($this->form->language_disclaimer > 0 && $this->form->casting_fee > 0){
                            $this->steps[$step] = true;      
                            $this->dispatch('livewire-step-validated', tab: 'tab-1-3');
                        } else {
                            $this->steps[$step] = false;
                            session()->flash('message', 'Please Check all the boxes');
                        }
                    }
                break;
                case 3:
                    if ($this->form->emergency_2_contact && $this->form->emergency_2_relationship && $this->form->emergency_2_tel){
                        $this->steps[$step] = true;      
                        $this->dispatch('livewire-step-validated', tab: 'tab-1-4');
                    } else {
                        $this->steps[$step] = false;
                        session()->flash('message', 'Please Check you have filled out the required information');
                    }
                break;
                case 4:
                    if ($this->form->auditionee->ageAtDate($this->project->end_date) > 17) {
                        if ($this->form->casting_offsite){
                            $this->steps[$step] = true;      
                            $this->dispatch('livewire-step-validated', tab: 'tab-1-5');
                        } else {
                            $this->steps[$step] = false;
                            session()->flash('message', 'Please Check you have filled out the required information');
                        }
                    } else {
                        $this->steps[$step] = true;      
                        $this->dispatch('livewire-step-validated', tab: 'tab-1-5');
                    }
                break;
                case 5:
                    if ($this->form->birth_gender && $this->form->consent){
                        $this->steps[$step] = true;      
                        $this->dispatch('livewire-step-validated', tab: 'tab-1-6');
                    } else {
                        $this->steps[$step] = false;
                        session()->flash('message', 'Please Check you have filled out the required information');
                    }
                break;
                
            }
            
        } 
    }
    

    public function decline()
    {
        
        $this->auditionee = AuditioneeRole::updateOrCreate(['id' => $this->roleId], [
            'status' => 0,
        ]);
        
        $to = $this->form->auditionee->email;
        
        if ($this->form->auditionee->secondary_email){
            Mail::to($to)->cc($this->form->auditionee->secondary_email)->send(new RoleDeclined($this->form->auditionee->id,$this->project->id));
        } else {
            Mail::to($to)->send(new RoleDeclined($this->form->auditionee->id,$this->project->id));
        }
        
        
        
        session()->flash('message', 'You have declined this offer');
        
        $this->formStatus = "Declined";
        $this->hideForm = true;
        
        
    }
    
    public function save()
    {
        $this->form->update();

        sleep(1);
        
        $this->auditionee = AuditioneeRole::updateOrCreate(['id' => $this->roleId], [
            'status' => 2,
        ]);
        
        $to = $this->form->auditionee->email;
        
        if ($this->form->auditionee->secondary_email){
            Mail::to($to)->cc($this->form->auditionee->secondary_email)->send(new RoleAccepted($this->form->auditionee->id,$this->project->id));
        } else {
            Mail::to($to)->send(new RoleAccepted($this->form->auditionee->id,$this->project->id));
        }
        
        session()->flash('message', 'Congratulations – you have accepted the role!');
        
        $this->formStatus = "Accepted";
        $this->hideForm = true;

        //redirect()->to('/payCourse/'.$this->form->auditionee_id.'/'.$this->course_id);
    }
    
    
    
}