<?php

namespace App\Livewire\Frontend;

use Livewire\Component;
use Livewire\Attributes\Validate;
use Illuminate\Http\Request;
use App\Models\VenueDate;

class Welcome extends Component
{
    
    public $applicationType = 'actor';
    public $showCategory = true;
    
    public $showModal = 0, $venuedates,$applicationTypeLabel;
    
    #[Validate('required', message: 'Please choose an Audition Date')]
    public $venuedate_id;
    
    public function mount(Request $request)
    {
                if ($request->type) {
                    $this->applicationType = $request->type;
                    $this->showCategory = false;
                }
    }
    
    
    public function render()
    {
        
        switch ($this->applicationType){
            case 'actor':
            $this->applicationTypeLabel = 'Actor Audition Workshop Days 2025 | Booking Form';
            break;
            case 'stage_manager':
            $this->applicationTypeLabel = 'Production Mentorship Scheme 2025';
            $this->venuedate_id = 0;
            break;
            case 'musician':
            $this->applicationTypeLabel = 'Musician Auditions 2025 | Booking Form';
            break;
            case 'cpp':
            $this->applicationTypeLabel = 'Creative & Production Pathway 2025 | Registration Form';
            $this->venuedate_id = 0;
            break;
        }
        
        $today = date('y-m-d');
        
        $query = VenueDate::where('id','>',0);
        
    	
    	$query->where('start_date','>=',$today);
    	$query->orderBy('start_date','asc');
        $this->venuedates = $query->limit(20)->get();
        
        
        return view('frontend.welcome')
            ->layout('layouts.frontend');
    }

    public function openModal()
    {
        $this->showModal = true;
    }
    public function closeModal()

    {
        $this->showModal = false;
    }
    
    
    public function register($id = null, $type = null)
    {
        $this->validate();
        if (!$id){
            $id = $this->venuedate_id;
        }
        if (!$type){
            $type = $this->applicationType;
        }
        
        return redirect()->to('/start/'.$this->venuedate_id.'/'.$this->applicationType);
    }
    
    
}