<?php
namespace App\Livewire\Frontend\Ycm;

use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class ParentLogin extends Component
{
    public string $email = '';
    public string $password = '';
    public string $error = '';

    public function login()
    {
        if (Auth::guard('auditionee_parent')->attempt(['email' => $this->email, 'password' => $this->password])) {
            session()->regenerate();
            return redirect()->intended(route('ycm.profile'));
        }

        $this->error = 'Invalid email or password.';
    }

    public function render()
    {
        return view('frontend.ycm.login')->layout('layouts.guest');
    }
}
