<?php

namespace App\Livewire\Frontend\Ycm;

use Livewire\Component;
use Livewire\Attributes\Validate;
use Livewire\WithFileUploads;
use Illuminate\Validation\Rule;
use App\Livewire\Auditionee\Forms\ProfileForm;
use App\Livewire\Auditionee\Forms\AuditionForm;
use App\Livewire\Auditionee\Forms\CommentForm;
use App\Livewire\Auditionee\Forms\RoleForm;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Models\Auditionee;
use App\Models\AuditioneeComment;
use App\Models\AuditioneeMedia;
use App\Models\Audition;
use App\Models\CommentCategory;
use App\Models\Project;
use App\Models\Recall;
use App\Models\Role;
use App\Models\Venue;
use App\Models\VenueDate;

class Profile extends Component
{
    
    use WithFileUploads;
    
    public ProfileForm $form;
    public AuditionForm $auditionform;
    public CommentForm $commentform;
    public RoleForm $roleform;

    public $crud, $chosenvenue = false;
    public $venues,$projects,$venuedates,$commentcategories,$roles;
    public $showAddAudition = false;
    public $showAddMedia = false;
    public $showAddRole = false;
    public $showAddCommentDialog = false;
    public $media;
    public $project_id = false;

    public function mount(Request $request)
    {
                if ($request->id) {
                    $this->form->setUser($request->id);
                    $this->auditionform->auditionee_id = $request->id;
                    $this->commentform->auditionee_id = $request->id;
                    $this->roleform->auditionee_id = $request->id;
                } else{
                    $this->form->dob = date('Y-m-d');
                    $this->form->password = 'NYMT'; // lets make this more random
                }
        
    }

    public function save()
    {
        $this->form->update();

        sleep(1);

        session()->flash('message', 'Profile Successfully Updated.');
    }
    
    

    
    public function addMedia(){
        
        
        if ($this->media){
        $this->validate([
            'media' => 'mimes:jpeg,jpg,png,gif,pdf,doc,docx,mp4,mov|max:4094', // 4MB Max
        ]);

        $fileName = Str::slug(strip_tags($this->media->getClientOriginalName()), '-');
        
        $extension = $this->media->extension();
        $fileName = str_replace($extension, '',$fileName).".".$extension;
    
        $this->media->storeAs('public/auditionee', $fileName);
        
        
        $newrank = $this->form->auditionee->media->max('rank') + 1;
        
        AuditioneeMedia::create([
            'url' => $fileName,
            'status' => 1,
            'auditionee_id' => $this->form->auditionee->id,
            'rank' => $newrank
            ]);
        
        }
        
        sleep(1);
        session()->flash('message', 'Media Successfully Added.');
        
        $this->reset('showAddMedia');
        redirect()->to('/auditionees/edit/'.$this->form->auditionee_id);
    }
    
    public function deleteMedia($id)
    {
        $audition = AuditioneeMedia::find($id);
        $audition->delete();
        session()->flash('message', 'Media Deleted Successfully.');
    }
    
    


    public function render()
    {
        
        $this->venues = Venue::all()->sortBy("name");
        $this->projects = Project::all()->sortBy("name");
        
        $query = CommentCategory::where('id','>',0);
        
        if ($this->commentform->commentgroup) {
            $query->where('type','=',$this->commentform->commentgroup);
        }
        
        $this->commentcategories = $query->orderBy("name")->get();
        
        $query = VenueDate::where('id','>',0);
        
        // venue filter
    	if(strlen($this->chosenvenue)>=1){
    	    
    	    $venueResult = $this->chosenvenue;
    	    
    		$query->where('venue_id','=',$venueResult);
    	}
    	
    	$this->venuedates = $query->orderBy("start_date")->get();
        $this->roles = false;
    	if($this->project_id > 0 ){
            $this->roles = Role::where('project_id', $this->project_id)->get();
    	}
    	
        
        $this->crud = "Create";
        if ($this->form->auditionee_id){
        $this->crud = "Update";
        }
        
        return view('frontend.ycm.casting')
            ->layout('layouts.frontend-ycm');
    }
    
    public function excerpt($text, $length)
    {
        return Str::limit($text, $length);
    }
    
    
}