<?php

namespace App\Livewire\Project;

use Livewire\Component;
use Livewire\Attributes\Validate;
use Livewire\WithFileUploads;
use Illuminate\Validation\Rule;
use App\Livewire\Project\Forms\MainForm;
use Illuminate\Http\Request;
use App\Models\Role;
use App\Models\Recall;
use App\Models\Auditionee;
use App\Models\AuditioneeRole;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log; // Import Log

class Edit extends Component
{
    use WithFileUploads;
    public MainForm $form;
    
    #[Rule('required')]
    public $chosenycm = '';
    
    #[Rule('required')]
    public $activeRoleId = '';
    public $status = 1;
    public $choice = 1;
    
    public $search = '';
    public $availableAuditionees = [];
    
    public $showSuccessIndicator = false, $crud;

    public function mount(Request $request)
    {
                if ($request->id) {
                    $this->form->setProject($request->id);
                } else {
                    $this->form->project_id = false;
                    $this->form->cast_date = date('Y-m-d');
                    $this->form->start_date = date('Y-m-d');
                    $this->form->end_date = date('Y-m-d', strtotime('tomorrow'));
                }
    }

    public function save()
    {
        
        if ($this->form->project_id){
            $message = "Updated";
        } else {
            $message = "Created";
        }
        $this->form->update();
        $this->crud = "Update";
        
        sleep(1);
        
        session()->flash('message', 'Project '.$message.' Successfully.');

    }

    public function render()
    {
        
        $this->crud = "Create";
        if ($this->form->project_id){
        $this->crud = "Update";
        }
        return view('nymt.project.edit');
    }
    
    
    public function assignRole()
    {

        AuditioneeRole::create([
            'auditionee_id' => $this->chosenycm,
            'role_id' => $this->activeRoleId,
            'choice' => $this->choice,
            'status' => $this->status,
        ]);
        
        sleep(1);
        session()->flash('message', 'Auditionee Successfully Added.');
        
        $this->reset('chosenycm', 'availableAuditionees');
    }
    

    public function updatedSearch()
    {
        if (strlen($this->search) > 2) { // Prevent unnecessary queries
            $this->availableAuditionees = Auditionee::where('firstname', 'like', '%' . $this->search . '%')
                ->orWhere('lastname', 'like', '%' . $this->search . '%')
                ->orWhere('email', 'like', '%' . $this->search . '%')
                ->limit(10)
                ->get(['id', 'firstname', 'lastname', 'email'])
                ->map(function ($auditionee) {
                    return [
                        'id' => $auditionee->id,
                        'name' => "{$auditionee->firstname} {$auditionee->lastname} ({$auditionee->email})",
                    ];
                })
                ->toArray();
 
        } else {
            $this->availableAuditionees = [];
        }
    }
    
    public function selectAuditionee($id,$activeRoleId)
    {
        $this->activeRoleId = $activeRoleId;
        $selected = collect($this->availableAuditionees)->firstWhere('id', $id);
        if ($selected) {
            $this->chosenycm = $id;
            $this->search = $selected['name']; // Show selected name in input
        }
        $this->availableAuditionees = []; // Hide the dropdown after selection
    }


    
    public function addRole($id)
    {
        redirect()->to('/roles/create/'.$id);
    }
    public function editRole($id)
    {
        redirect()->to('/roles/edit/'.$id);
    }
    
    public function deleteRole($id)
    {
        $role = Role::find($id);
        $rolePosition = $role->position;
        DB::transaction(function() use ($role,$rolePosition) {
            Role::where('position','>',$rolePosition)->decrement('position');
            $role->delete();
        });

        session()->flash('message', 'Role Deleted Successfully.');
    
    }
    
    public function sortItem($id, $newPosition)
    {
        $projectId = $this->form->project_id;
        // Get roles within the same project, sorted by position
        $roles = Role::where('project_id', $projectId)
            ->orderBy('position')
            ->get()
            ->values(); // Reindex the collection
    
        $roleToMove = $roles->firstWhere('id', $id);
    
        if (!$roleToMove) return;
    
        // Remove the item from the current collection
        $roles = $roles->reject(fn($role) => $role->id === $id);
    
        // Clamp new position and insert the item back in
        $newPosition = max(0, min($newPosition, $roles->count()));
        $roles->splice($newPosition, 0, [$roleToMove]);
    
        // Reassign all positions within the project, starting at 1
        foreach ($roles as $index => $role) {
            $role->update(['position' => $index + 1]);
        }
    }
    
    
    
    public function addRecall($id)
    {
        redirect()->to('/recalls/create/'.$id);
    }
    public function editRecall($id)
    {
        redirect()->to('/recalls/edit/'.$id);
    }
    
    public function deleteRecall($id)
    {
        $user = Recall::find($id);
        $user->delete();

        session()->flash('message', 'Recall Deleted Successfully.');
    
    }
}