<?php

namespace App\Livewire\Project\Forms;

use Livewire\Form;
use Livewire\WithFileUploads;
use Livewire\Attributes\Validate;
use Illuminate\Validation\Rule;
use Illuminate\Support\Str;
use App\Models\Project;

class MainForm extends Form
{
    use WithFileUploads;
    
    public Project $project;
    #[Validate('required|min:3', onUpdate: false)]
    public $name= ''; 
    public $type= ''; 
    public $details= ''; 
    public $cast_date = '';
    public $start_date = '';
    public $end_date =  '';
    
    public $project_id = false;
    

    public function setProject($id)
    {
        
        $this->project = Project::find($id);
        
        if ($this->project){
        $this->project_id = $this->project->id;
        $this->name = $this->project->name;
        $this->type = $this->project->type;
        $this->cast_date = date('Y-m-d' , strtotime($this->project->cast_date));
        $this->start_date = date('Y-m-d' , strtotime($this->project->start_date));
        $this->end_date = date('Y-m-d' , strtotime($this->project->end_date));
        $this->details = $this->project->details;
        } 

    }
    

    public function update()
    {
        $this->validate();
        
        Project::updateOrCreate(['id' => $this->project_id], [
            'name' => $this->name,
            'type' => $this->type,
            'cast_date' => date('Y-m-d H:i:s' , strtotime($this->cast_date)),
            'start_date' => date('Y-m-d H:i:s' , strtotime($this->start_date)),
            'end_date' => date('Y-m-d H:i:s' , strtotime($this->end_date)),
            'details' => $this->details
        ]);
        
        
    }
}