<?php

namespace App\Livewire\Project\Forms;

use Livewire\Form;
use Livewire\WithFileUploads;
use Livewire\Attributes\Validate;
use Illuminate\Validation\Rule;
use Illuminate\Support\Str;
use App\Models\Role;

class RoleForm extends Form
{
    use WithFileUploads;
    
    public Role $role;
    
    #[Validate('required|min:3', onUpdate: false)]
    public $name= ''; 
    public $comment = '';
    public $position = 0;
    public $project_id = null;
    
    public $role_id = false;
    
    

    public function setRole($id)
    {
        
        $this->role = Role::find($id);
        
        if ($this->role){
            
            $this->role_id = $this->role->id;
            $this->name = $this->role->name;
            $this->comment = $this->role->comment;
            $this->position = $this->role->position;
            $this->project_id = $this->role->project_id;
        
        } 

    }
    

    public function update()
    {
        $this->validate();
    
        if ($this->position < 1) {
            $this->position = Role::where('project_id', $this->project_id)->max('position') + 1;
        }
    
        $role = Role::updateOrCreate(
            ['id' => $this->role_id],
            [
                'name' => $this->name,
                'comment' => $this->comment,
                'position' => $this->position,
                'project_id' => $this->project_id,
            ]
        );
    
            return redirect()->to('/roles/edit/' . $role->id);
    }

}