<?php

namespace App\Livewire\Venue;

use Livewire\Component;
use Livewire\Attributes\Validate;
use Livewire\WithFileUploads;
use Illuminate\Validation\Rule;
use App\Livewire\Venue\Forms\MainForm;
use Illuminate\Http\Request;
use App\Models\VenueDate;

class Edit extends Component
{
    use WithFileUploads;
    public MainForm $form;
    
    public $showSuccessIndicator = false, $crud;

    public function mount(Request $request)
    {
                if ($request->id) {
                    $this->form->setVenue($request->id);
                } else {
                    $this->form->venue_id = false;
                }
    }

    public function save()
    {
        
        if ($this->form->venue_id){
            $message = "Updated";
        } else {
            $message = "Created";
        }
        $this->form->update();
        $this->crud = "Update";
        
        sleep(1);
        
        session()->flash('message', 'Venue '.$message.' Successfully.');

        //return redirect()->to('/venues/');
    }

    public function render()
    {
        
        $this->crud = "Create";
        if ($this->form->venue_id){
        $this->crud = "Update";
        }
        return view('nymt.venue.edit');
    }
    
    
    
    public function addDate($id)
    {
        redirect()->to('/venuedates/create/'.$id);
    }
    public function editDate($id)
    {
        redirect()->to('/venuedates/edit/'.$id);
    }
    
    public function deleteDate($id)
    {
        $user = VenueDate::find($id);
        $user->delete();

        session()->flash('message', 'Venue Date Deleted Successfully.');
    
    }
}