<?php

namespace App\Livewire\Venue\Forms;

use Livewire\Form;
use Livewire\WithFileUploads;
use Livewire\Attributes\Validate;
use Illuminate\Validation\Rule;
use Illuminate\Support\Str;
use App\Models\Venue;

class MainForm extends Form
{
    use WithFileUploads;
    
    public Venue $venue;
    #[Validate('required|min:3', onUpdate: false)]
    public $name= ''; 
    public $address = '';
    #[Validate('required|min:3', onUpdate: false)]
    public $town = '';
    #[Validate('required|min:3', onUpdate: false)]
    public $postcode = '';
    public $email = '';
    public $website = '';
    public $tel = '';
    public $capacity = '';
    
    public $venue_photo;
    public $venue_photo_path;
    public $venue_id = false;
    

    public function setVenue($id)
    {
        
        $this->venue = Venue::find($id);
        
        if ($this->venue){
        $this->venue_id = $this->venue->id;
        $this->name = $this->venue->name;
        $this->address = $this->venue->address;
        $this->town = $this->venue->town;
        $this->postcode = $this->venue->postcode;
        $this->email = $this->venue->email;
        $this->website = $this->venue->website;
        $this->tel = $this->venue->tel;
        $this->capacity = $this->venue->capacity;
        $this->venue_photo_path = $this->venue->venue_photo_path;
        } 

    }
    

    public function update()
    {
        $this->validate();
        
        if ($this->venue_photo){
        $fileName = Str::slug(strip_tags($this->venue_photo->getClientOriginalName()), '-');
        
        $extension = $this->venue_photo->extension();
        $fileName = str_replace($extension, '',$fileName).".".$extension;
        $this->venue_photo_path = $fileName;
    
        $this->venue_photo->storeAs('public/venues', $fileName);
        }
        
        $this->venue_photo = '';
        Venue::updateOrCreate(['id' => $this->venue_id], [
            'name' => $this->name,
            'address' => $this->address,
            'town' => $this->town,
            'postcode' => $this->postcode,
            'email' => $this->email,
            'website' => $this->website,
            'tel' => $this->tel,
            'capacity' => $this->capacity,
            'venue_photo_path' => $this->venue_photo_path
        ]);
        
        
    }
}