<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\VenueDate;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Validation\Rule;

class VenueDates extends Component
{
    use WithPagination;
    
    protected $queryString = ['sortField','sortDirection'];
    public $venue_id, $statusclass;
    
    public $isOpen = 0,  $template = 'grid', $inputsearch;
    public $sortField = 'start_date', $sortDirection = 'asc', $perPage = '20';
    

    public function render()
    {
        
        $query = VenueDate::where('id','>',0);
        
               // live filter
    	if(strlen($this->inputsearch)>=1){
    	    
    	    $searchResult = $this->inputsearch;
    	    
    		$query->where('name','like','%'.$searchResult.'%');
    	}
    	
    	// deal with sortby
    	
    	$query->orderBy($this->sortField,$this->sortDirection);


        return view('nymt.venuedates', [
            'myvenuedates' => $query->paginate($this->perPage),
            ]);

    }
    
    
    public function sortBy($field){
        
        if ($this->sortField === $field) {
            $this->sortDirection = $this->sortDirection ==='asc' ? 'desc' : 'asc';
        } else {
            $this->sortDirection ='asc';
        }
        
    $this->sortField = $field;
    }
    
    public function auditionlist($id){
        
        return redirect()->to('/auditionees/audition-list/'.$id.'?view=list');
    }


    public function edit($id)

    {
        return redirect()->to('/venuedates/edit/'.$id);
    }

    public function delete($id)

    {
        $user = VenueDate::find($id);
        $user->delete();

        session()->flash('message', 'Venue Date Deleted Successfully.');
    }
}