<?php

namespace App\Mail;

use App\Models\Auditionee;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\URL;


class CppPaid extends Mailable


{
    use Queueable, SerializesModels;
    
    public Auditionee $auditionee;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(private $auditionee_id)
    {
        
        $this->auditionee = Auditionee::find($auditionee_id);
        //
    }

    /**
     * Get the message envelope.
     *
     * @return \Illuminate\Mail\Mailables\Envelope
     */

    public function envelope()
    {
        return new Envelope(
            subject: 'NYMT | Thank you for paying – your Creative & Production Pathway application is confirmed',
        );
    }
 /**
     * Get the message content definition.
     *
     * @return \Illuminate\Mail\Mailables\Content
     */

    public function content(): Content
    {
        
        $firstname = $this->auditionee->firstname;
        $lastname = $this->auditionee->lastname;
        
        
        return new Content(
            markdown: 'emails.frontend.cpp-paid',
            with: [
                'firstname' => $firstname,
                'lastname' => $lastname,
            ],
        );
    }
    

    /**
     * Get the attachments for the message.
     *
     * @return array
     */
    public function attachments()
    {
        return [];
    }
}