<?php

namespace App\Mail;

use App\Models\Auditionee;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\URL;


class ProfileUpdate extends Mailable


{
    use Queueable, SerializesModels;
    
    public Auditionee $auditionee;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(private $auditionee_id)
    {
        $this->auditionee = Auditionee::find($auditionee_id);
        //
    }

    /**
     * Get the message envelope.
     *
     * @return \Illuminate\Mail\Mailables\Envelope
     */

    public function envelope()
    {
        return new Envelope(
            subject: 'NYMT | Please update your profile',
        );
    }
 /**
     * Get the message content definition.
     *
     * @return \Illuminate\Mail\Mailables\Content
     */

    public function content(): Content
    {
        
        $detailsUrl = 
         URL::temporarySignedRoute(
            'ycm.details', now()->addDays(3), [
                    'id' => $this->auditionee->id,
                ]
        );
        
        
        $firstname = $this->auditionee->firstname;
        $lastname = $this->auditionee->lastname;
        
        $castrole = "";
        $project = "";
        $course = $this->auditionee->course;
        
        if ($this->auditionee->course){
            $project = $this->auditionee->course->name;
        } else {
        
            $roles = $this->auditionee->roles;
            if ($roles) {
                foreach ($roles as $role){
                        $castrole = $role->role->name;
                        $project = $role->role->project->name;
                }
            } 
        
        }
        
        return new Content(
            markdown: 'emails.frontend.role-offer',
            with: [
                'detailsUrl' => $detailsUrl,
                'firstname' => $firstname,
                'lastname' => $lastname,
                'project' => $project,
            ],
        );
    }
    

    /**
     * Get the attachments for the message.
     *
     * @return array
     */
    public function attachments()
    {
        return [];
    }
}