<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


class Attendee extends Model
{
    
    use HasFactory;
      

    protected $guarded = [];
    

    public function auditionee(){
       return $this->belongsTo(Auditionee::class);
    }
    public function course(){
       return $this->belongsTo(Course::class);
    }
    
    
    public function transaction(){
       return $this->belongsTo(AuditioneeTransaction::class, 'auditionee_transaction_id');
    }
    
    public function paid(){
        if ($this->transaction){
            return "Yes - £".$this->transaction->amount;
        } else {
            return "Not yet";
        }
    }
    
    
    public function next(){
        return Attendee::where('id', '>', $this->id)
            ->where('course_id', '=', $this->course_id)
            ->orderBy('id','asc')
            ->first();
    }
    public function previous(){
        return Attendee::where('id', '<', $this->id)
            ->where('course_id', '=', $this->course_id)
            ->orderBy('id','desc')
            ->first();
    }
    
}