<?php
namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;

class AuditioneeParent extends Authenticatable implements MustVerifyEmail
{
    use Notifiable;

    protected $fillable = ['firstname', 'lastname', 'email', 'password'];

    protected $hidden = ['password', 'remember_token'];

    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function auditionees()
    {
        return $this->hasMany(Auditionee::class);
    }
}