<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


class Course extends Model
{
    
    use HasFactory;
      

    protected $guarded = [];
    
    
    protected $casts = [
        'start_date' => 'date:Y-m-d',
        'end_date' => 'date:Y-m-d',
        'price' => 'decimal:2',
    ];
    

    public function isresidential() {
        
        if ($this->residential == 0){
            return "No";
        } else {
            return "Yes";
        }
        
    }

    public function attendees(){
       return $this->hasMany(Attendee::class);
    }
    
    public function availability($margin = 0){
        
       $capacity = $this->capacity + $margin;
       $booked = count($this->attendees);
       
       if ($booked < $capacity) {
           return true;
       }
        
       return false;
    }
    
    
}