<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


class VenueDate extends Model
{
    
    use HasFactory;
      

    protected $guarded = [];
    
    
    protected $casts = [
        'start_date' => 'date:Y-m-d',
        'end_date' => 'date:Y-m-d',
    ];
    
    
    public function venue(){
       return $this->belongsTo(Venue::class);
    }
    public function project(){
       return $this->belongsTo(Project::class);
    }

    public function auditions(){
       return $this->hasMany(Audition::class);
    }
    
    
    public function actorauditions(){
        
        return $this->auditions()->whereHas('auditionee', function($query) {
                    $query->where('category', 'actor');
                })->get();
    }
    
    public function availability(){
        
       $capacity = $this->capacity + $this->margin ;
       $booked = count($this->actorauditions());
       
       if ($capacity == 0){
            return false;
       }
       
       if ($booked < $capacity) {
           return true;
       }
        
       return false;
    }
    public function availabilityLabel(){
       $capacity = $this->capacity + $this->margin ;
       $booked = count($this->actorauditions());
       
       if ($capacity == 0){
            return "Not Available";
       }
       
       if ($booked < $capacity) {
           return ($capacity - $booked)." places available";
       }
        
       return "Fully Booked";
    }
    
    public function availabilityClass(){
        
       $capacity = $this->capacity + $this->margin ;
       $booked = count($this->actorauditions());
       
        if ($capacity == 0){
           return "bg-slate-200";
       }
       
       if ($booked < $capacity) {
           return "bg-green-200";
       }
        
       return "bg-red-200";
    }
    
    
    public function musicianauditions(){
        
        return $this->auditions()->whereHas('auditionee', function($query) {
                    $query->where('category', 'musician');
                })->get();
    }
    public function musicianavailability(){
        
        
        $capacity = $this->musicians;
        $booked = count($this->musicianauditions());
       
        if ($capacity == 0){
            return false;
        }
       
        if ($booked < $capacity) {
           return true;
        }
        
        return false;
    }
    public function musicianavailabilityLabel(){
       $capacity = $this->musicians ;
       $booked = count($this->musicianauditions());

       
       if ($capacity == 0){
            return "Not Available";
       }
       
       if ($booked < $capacity) {
           return ($capacity - $booked)." places available";
       }
        
       return "Fully Booked";
    }
    public function musicianavailabilityClass(){
        
       $capacity = $this->musicians;
       $booked = count($this->musicianauditions());
       
       if ($capacity == 0){
           return "bg-slate-200";
       }
       
       if ($booked < $capacity) {
           return "bg-green-200";
       }
        
       return "bg-red-200";
    }
    
}