<?php

namespace App\Policies;

use App\Models\Team;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class TeamPolicy
{
    use HandlesAuthorization;
    
    
    /**
     * Determine whether the user can add team members.
     */
    public function blockCreative(User $user, Team $team): bool
    {
        //return $user->ownsTeam($team);
        return (!$user->hasTeamRole($team, 'editor'));
    }
    public function blockPastoral(User $user, Team $team): bool
    {
        //return $user->ownsTeam($team);
        return (!$user->hasTeamRole($team, 'pastoral'));
    }
    public function onlyAdmin(User $user, Team $team): bool
    {
        //return $user->ownsTeam($team);
        return ($user->ownsTeam($team) || $user->hasTeamRole($team, 'superadmin') || $user->hasTeamRole($team, 'admin'));
    }
    

    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        return true;
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user, Team $team): bool
    {
        return $user->belongsToTeam($team);
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        return true;
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, Team $team): bool
    {
        //return $user->ownsTeam($team);
        return ($user->ownsTeam($team) || $user->hasTeamRole($team, 'superadmin'));
    }

    /**
     * Determine whether the user can add team members.
     */
    public function addTeamMember(User $user, Team $team): bool
    {
        //return $user->ownsTeam($team);
        return ($user->ownsTeam($team) || $user->hasTeamRole($team, 'superadmin'));
    }
    
    
    public function createTeam(User $user): bool
    {
        return false;
    }

    /**
     * Determine whether the user can update team member permissions.
     */
    public function updateTeamMember(User $user, Team $team): bool
    {
        //return $user->ownsTeam($team);
        return ($user->ownsTeam($team) || $user->hasTeamRole($team, 'superadmin'));
    }

    /**
     * Determine whether the user can remove team members.
     */
    public function removeTeamMember(User $user, Team $team): bool
    {
        return $user->ownsTeam($team);
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, Team $team): bool
    {
        return $user->ownsTeam($team);
    }
}
