<div
    x-data="
        {
             newValue: @js($origValue),
             isEditing: false,
             isName: '{{ $isValue }}',
             @if ($input == "score")
             isInt: true,
             @else
             isInt: false,
             @endif
             focus: function() {
                const textInput = this.$refs.textInput;
                textInput.focus();
                textInput.select();
             }
        }
    "
    x-cloak
>
    <div
        class="px-0 w-full"
        x-show=!isEditing
    >
        <span class="block"
            @dblclick="isEditing = true; $nextTick(() => focus())"
        >@if ($origValue)
        
            @if ($input == "role")
            {{ $lookupValue }}
            @else
            {{ $origValue }}
            @endif
         @else
            <em class="text-gray-300">Double-click to add</em>
         @endif
            </span>
    </div>
    <div x-show=isEditing class="flex flex-col bg-white" style="display:none;" x-on:click.away="$wire.saveAlpine('{{ $field }}',newValue,isInt);isEditing = false;">
        <form class="flex" wire:submit.prevent="save('{{ $field }}')">
            @if ($input == "textarea")
            <textarea
                class="px-0 mx-0 font-bold w-9/12"
                rows="5"
                placeholder=""
                x-ref="textInput"
                wire:model.defer="newValue"
                x-model = "newValue"
                x-on:keydown.enter="
                    if ($event.shiftKey) {
                        $event.preventDefault();
                    isEditing = false
                    }
                "
                x-on:keydown.escape="isEditing = false"
            ></textarea>
            @elseif ($input == "score")
            <select
                class="px-0 mx-0 font-bold w-9/12"
                placeholder=""
                x-ref="textInput"
                wire:model.defer="newValue"
                x-model = "newValue"
                x-on:keydown.enter="isEditing = false"
                x-on:keydown.escape="isEditing = false"
                >
                ><option value="0">Choose Score</option>
                 <x-nymt.options.score></x-nymt.options.score>
             </select>
            @elseif ($input == "outcome")
            <select
                class="px-0 mx-0 font-bold w-9/12"
                placeholder=""
                x-ref="textInput"
                wire:model.defer="newValue"
                x-model = "newValue"
                x-on:keydown.enter="isEditing = false"
                x-on:keydown.escape="isEditing = false"
                ><option value="">Choose Outcome</option>
                 <x-nymt.options.outcome></x-nymt.options.outcome>
             </select>
            @elseif ($input == "role")
            <select
                class="px-0 mx-0 font-bold w-9/12"
                placeholder=""
                x-ref="textInput"
                wire:model.defer="newValue"
                x-model = "newValue"
                x-on:keydown.enter="isEditing = false"
                x-on:keydown.escape="isEditing = false"
                >
                ><option value="">Choose Outcome</option>
                 <x-nymt.options.outcome></x-nymt.options.outcome>
             </select>
            @else    
            <input
                type="text"
                class="px-0 mx-0 font-bold w-9/12"
                placeholder=""
                x-ref="textInput"
                wire:model.defer="newValue"
                x-model = "newValue"
                x-on:keydown.enter="isEditing = false"
                x-on:keydown.escape="isEditing = false"
            >
            @endif    
            <button type="button" class="px-1 ml-1 text-2xl w-1/12" title="Cancel" x-on:click="isEditing = false">𐄂</button>
            <button
                type="submit"
                class="px-1 ml-1 text-xl font-bold text-green-600 w-1/12"
                title="Save" 
                x-ref="editForm"
                x-on:click="isEditing = false"
            >✓</button>
        </form>
    </div>
</div>