@props([
    'label' => false,
    'model' => false,
    'modelvalue' => false
])
    <!-- Toggle -->
<div
    @if ($modelvalue == 1)
    x-data="{ value: true}" 
    @else
    x-data="{ value: false}" 
    @endif
    class="flex items-center justify-center"
    x-id="['toggle-label']"
>
    <input type="hidden" name="sendNotifications" :value="value"
     @if ($model)
        wire:model.live="{{ $model }}"
        @endif
    >
 
    <!-- Label -->
    @if ($label)
    <label
        @click="$refs.toggle.click(); $refs.toggle.focus()"
        :id="$id('toggle-label')"
        class="block text-gray-700 text-sm font-bold mb-2"
    >
        {{ $label }}
    </label>
    @endif
 
    <!-- Button -->
    <button
        x-ref="toggle"
        @click="value = ! value"
        type="button"
        role="switch"
        :aria-checked="value"
        :aria-labelledby="$id('toggle-label')"
        :class="value ? 'bg-slate-400' : 'bg-slate-300'"
        class="relative ml-4 inline-flex w-14 rounded-full py-1 transition"
    >
        <span
            :class="value ? 'translate-x-7' : 'translate-x-1'"
            class="bg-white h-6 w-6 rounded-full transition shadow-md"
            aria-hidden="true"
        ></span>
    </button>
</div>