@props(['id' => null, 'maxWidth' => null])

@php
$id = $id ?? md5($attributes->wire('model'));
switch ($maxWidth ?? '2xl') {
    case 'sm':
        $maxWidth = 'sm:max-w-sm';
        break;
    case 'md':
        $maxWidth = 'sm:max-w-md';
        break;
    case 'lg':
        $maxWidth = 'sm:max-w-lg';
        break;
    case 'xl':
        $maxWidth = 'sm:max-w-xl';
        break;
    case '2xl':
    default:
        $maxWidth = 'sm:max-w-2xl';
        break;
}
@endphp

<div {{ $attributes->merge(['class' => 'fixed z-10 inset-0 overflow-y-auto ease-out duration-400']) }}>

  <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">

      

    <div class="fixed inset-0 transition-opacity">

      <div class="absolute inset-0 bg-gray-500 opacity-75"></div>

    </div>

  

    <!-- This element is to trick the browser into centering the modal contents. -->

    <span class="hidden sm:inline-block sm:align-middle sm:h-screen"></span>

  

    <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:w-full {{ $maxWidth }}" role="dialog" aria-modal="true" aria-labelledby="modal-headline">
        
    
    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
        <div class="sm:flex sm:items-start">

            <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left">
                <div class="mt-2">
                    {{ $content }}
                </div>
            </div>
        </div>
      </div>
    
    <div class="px-6 py-4 bg-gray-100 text-right">
        {{ $footer }} </div>

    </div>

  </div>

</div>