<div
    x-data="
        {
             newValue: '{{ $origValue }}',
             isEditing: false,
             isName: '{{ $isValue }}',
             focus: function() {
                const textInput = this.$refs.textInput;
                textInput.focus();
                textInput.select();
             }
        }
    "
    x-cloak
>
    <div
        class="px-0 w-full"
        x-show=!isEditing
    >
        <span class="block"
            @dblclick="isEditing = true; $nextTick(() => focus())"
        >@if ($origValue)
            {{ $origValueName }}
         @else
            <em class="text-gray-300">NULL</em>
         @endif
            </span>
    </div>
    <div x-show=isEditing class="flex flex-col bg-white" style="display:none;" x-on:click.away="$wire.saveAlpine('{{ $field }}',newValue);isEditing = false;">
        <form class="flex" wire:submit.prevent="save('{{ $field }}')">
            <select
                type="text"
                class="px-0 mx-0 font-bold w-9/12"
                placeholder=""
                x-ref="textInput"
                wire:model.defer="newValue"
                x-model = "newValue"
                x-on:keydown.enter="isEditing = false"
                x-on:keydown.escape="isEditing = false"
            >
                            @foreach($product_type_list as $product_type)
                            <option value="{{ $product_type->id }}"> {{ $product_type->name }} </option>
                            @endforeach 
            </select>
            
            
            
            <button type="button" class="px-1 ml-1 text-2xl w-1/12" title="Cancel" x-on:click="isEditing = false">𐄂</button>
            <button
                type="submit"
                class="px-1 ml-1 text-xl font-bold text-green-600 w-1/12"
                title="Save" 
                x-ref="editForm"
                x-on:click="isEditing = false"
            >✓</button>
        </form>
    </div>
</div>