@component('mail::message')

Hello {{ $firstname }}, 

Thank you for your application to become a young company member of NYMT’s 2025 season. We look forward to seeing you at the audition day. 

When you arrive, please sign in with our friendly pastoral team. They are there to look after you and will be a main point of contact for you if you need any support or have any questions. 

<h3>Date and time:</h3>

{{ date('l, j F Y', strtotime($audition_date)) }}<br>
2pm – 5:30pm

Registration opens at 1:30pm. 

<h3>Location:</h3>

{{ $venue_name }}  
{!! $venue_address !!}

{{ $venue_website }}  


<h3>What to prepare and what to bring:</h3>

Please read the <a href="https://nymtuk.sharepoint.com/:b:/s/PublicFiles/EeeWiixRF39LmGcyy1NQqVMBxoggl-12DCqLS7x_TpBp3A?e=ZOO6dk">information pack</a>, which has lots of information about your audition.

Please also download the <a href="https://nymtuk.sharepoint.com/:b:/s/PublicFiles/EVDOA1XbIN5AuONfIrH_sY0B_ISiIII-2zWr0IIVamND1Q?e=0MzZ4N">workshop material pack</a>. Following the instructions in the information pack, print the part you need, or bring it on a digital device. 

You should wear whatever you feel comfortable wearing.

Just a reminder that a keyboard will be provided for pianists and a drum kit for percussionists. Otherwise, if your instrument is too large to bring with you, please contact us to discuss your audition. 

Please bring a named bottle of water to keep yourself hydrated.

<h3>Other Information:</h3>

{!! $audition_email_text !!}  

We hope you're looking forward to the day just as much as we're looking forward to meeting you. Most of all please remember that we want these auditions to be fun for everyone. So please enjoy every aspect of the afternoon, and if there's anything else we can do to make this experience a more positive one, do tell us. 

Best wishes, 

<b>Team NYMT</b> 
enquiries@nymt.org.uk 

@endcomponent