  <x-slot name="header">
    <div class="flex">
        
        <div><x-nymt.html.title>{{ $crud }}</x-nymt.html.title></div>

    
    </div>

    </x-slot>

    <x-nymt.body>

    <div class="grid grid-cols-1">
       
            @if ($course_id > 0)
                <x-nymt.html.h4title>{{$course->name }} | {{ date('l j M' , strtotime($course->start_date)) }} to {{ date('l j M Y' , strtotime($course->end_date)) }} | Price: &pound;{{$course->price }}</x-nymt.html.h4title>
        
            @endif
            
            <br/>
    <form wire:submit.prevent="save">
    <x-nymt.tabs.alt>
        <x-slot name="head">
            <x-nymt.tabs.label-alt>1</x-nymt.tabs.label-alt>
            @if ($steps[1])
            <x-nymt.tabs.label-alt>2</x-nymt.tabs.label-alt>
            @endif
            @if ($steps[2])
            <x-nymt.tabs.label-alt>3</x-nymt.tabs.label-alt>
            @endif
            @if ($steps[3])
            <x-nymt.tabs.label-alt>4</x-nymt.tabs.label-alt>
            @endif
            @if ($steps[4])
            <x-nymt.tabs.label-alt>5</x-nymt.tabs.label-alt>
            @endif
            @if ($steps[5])
            <x-nymt.tabs.label-alt>6</x-nymt.tabs.label-alt>
            @endif
            @if ($steps[6])
            <x-nymt.tabs.label-alt>7</x-nymt.tabs.label-alt>
            @endif
            @if ($steps[7])
            <x-nymt.tabs.label-alt>8</x-nymt.tabs.label-alt>
            @endif
        </x-slot>

        <x-slot name="body">      
        
        
        
            <x-nymt.tabs.section class="p-1"> 
            
                <x-nymt.html.subtitle>1. Please choose the course you would like to book</x-nymt.html.subtitle>
                <x-nymt.input.select leadingAddOn="Category" model="form.category">
                    <option value="" selected>Please choose your category</option>
                    <x-nymt.options.categories></x-nymt.options.categories>
                </x-nymt.input.select>
                
                <x-nymt.input.select  model="course_id" label="Please select a course">
                    <option value="">Select your course</option>
                    @foreach ($courses as $thiscourse)
                        @if ($thiscourse->availability())
                            <option value= {{ $thiscourse->id }}>{{ date('j M Y', strtotime($thiscourse->start_date)) }} | {{ $thiscourse->name }} | &pound;{{ $thiscourse->price }} </option>
                        @endif
                    @endforeach
                </x-nymt.input.select>
                    
                @error('course_id')  <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                
                @if ($course_id > 0)
                <p class="text-sm">{{ $course->description }}</p>
                @endif
                    
                <div class="text-center">
                <div wire:loading.delay class="inline-flex pl-4 pr-4">
                    <svg class="animate-spin h-5 w-5 text-black" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                </div>
                @if ($course_id > 0)
                <x-nymt.button wire:click="validateStep(1)" class="text-center">Next</x-nymt.button>
                @endif
                </div>
            </x-nymt.tabs.section> 
            
            @if ($course_id > 0)
            
            <x-nymt.tabs.section class="p-1">   
                <x-nymt.html.subtitle>Section 2: Personal Information</x-nymt.html.subtitle>
                <x-nymt.input.text class="required" label="First Name" placeholder="Enter First Name" infotext="Enter the name you'd like to be known by" wire:model.live="form.firstname"></x-nymt.input.text>
                @error('form.firstname')  <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text class="required" label="Last Name" placeholder="Enter Last Name" wire:model.live="form.lastname" infotext=""></x-nymt.input.text>
                @error('form.lastname')   <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text label="Formal Name" placeholder="Enter Formal Name" wire:model.live="form.formalname" infotext="If you have a name you'd prefer us to use in public-facing material, like programmes, please enter it here."></x-nymt.input.text>
                <x-nymt.input.select class="required" model="form.gender" label="Gender">
                <option value="" selected>Choose your gender</option>
                <x-nymt.options.gender></x-nymt.options.gender>
                </x-nymt.input.select>
                @error('form.gender') <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text class="required" label="Date of Birth" wire:model.live="form.dob" date infotext="Please ensure you input the correct year of birth. You may find it easier to type in your date of birth."></x-nymt.input.text>
                @error('form.dob') <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text class="required" label="Main Contact Email" placeholder="Enter Email" wire:model.live="form.email" infotext="We'll send our contact emails here. For children under 18, this should be a parent or carer's address. If you have auditioned with us this year, please refer to the course booking link in your email, or email us at enquiries@nymt.org.uk for your personal booking link."></x-nymt.input.text>
                @error('form.email')  <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text label="Secondary Contact Email" placeholder="Enter Email" wire:model.live="form.secondary_email" infotext="Optional. We'll send a copy of our general information emails here too."></x-nymt.input.text>
                @error('form.secondary_email')  <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                
                <div class="text-center">
                <div wire:loading.delay class="inline-flex pl-4 pr-4">
                    <svg class="animate-spin h-5 w-5 text-black" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                </div>
                <x-nymt.button wire:click="validateStep(2)" class="text-center">Next</x-nymt.button>
                </div>
            </x-nymt.tabs.section> 
            <x-nymt.tabs.section class="p-1">   
                <x-nymt.html.subtitle>Section 3: Personal Information</x-nymt.html.subtitle>
                <x-nymt.input.text label="Mobile Number" placeholder="Enter Mobile Number" wire:model.live="form.tel" infotext="Optional. This is the contact number for the auditionee, if applicable. There's an opportunity to add an emergency/parent contact number later."></x-nymt.input.text>
                @error('form.tel') <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text class="required" label="Street Address" placeholder="Enter Street Address" wire:model.live="form.address"></x-nymt.input.text>
                @error('form.address') <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text class="required" label="Town / City" placeholder="Enter Town / City" wire:model.live="form.town"></x-nymt.input.text>
                @error('form.town') <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text class="required" label="Postcode" placeholder="Enter Postcode" wire:model.live="form.postcode"></x-nymt.input.text>
                @error('form.postcode') <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.select class="required" label="Country" model="form.country">
                    <option value="" selected>Choose your country</option>
                    @foreach (App\Enums\Country::cases() as $country)
                    <option value="{{ $country->value }}">{{ $country->label() }}</option>
                    @endforeach
                </x-nymt.input.select>
                @error('form.country') <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text type="file" class="required" label="Photo" wire:model.live="form.photo" infotext="Please upload a recent informal headshot to help us recognise you. The photo should be your head and shoulders only. We will not use this photo in public."></x-nymt.input.text>
                @error('form.photo') <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                
                @if ($form->photo) 
                    <div class="text-center"><img src="{{ $form->photo->temporaryUrl() }}" width="200"></div>
                    @endif
                
                <div class="text-center">
                <x-nymt.button @click="select('tab-1-2')" class="text-center">Back</x-nymt.button>
                
                <div wire:loading.delay class="inline-flex pl-4 pr-4">
                    <svg class="animate-spin h-5 w-5 text-black" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                </div>
                
                <x-nymt.button wire:click="validateStep(3)" class="text-center">Next</x-nymt.button>
                </div>
            </x-nymt.tabs.section> 
            
            <x-nymt.tabs.section class="p-1"> 
            
                    
                @if ($course->residential >0) 
                    <x-nymt.html.subtitle>4. Residential</x-nymt.html.subtitle>
                @else 
                    <x-nymt.html.subtitle>4. Non Residential</x-nymt.html.subtitle>
                @endif
                    
                <p>Your age at the end of the course: {{ $form->ageAtDate($course->end_date) }} </p>
                    
                    
                    
                @if ($form->ageAtDate($course->end_date) > 17)
                    
                <x-nymt.html.subtitle>Over 18s</x-nymt.html.subtitle>
                <p class="text-sm pb-2">NYMT is committed to protecting children and vulnerable groups and ensuring that their welfare is paramount in every project that it runs and in every aspect of its work.</p>

                <p class="text-sm pb-2">Safeguarding is everyone’s responsibility. Every adult in NYMT has a legal duty to protect children from abuse and to promote their welfare.</p>

                <p class="text-sm" pb-2>Please read our safeguarding policy, which contains important information about your responsibility as an adult: <a href="https://nymt.org.uk/safeguarding-policy" target="_blank">https://nymt.org.uk/safeguarding-policy/</a></p>
                    
                <x-nymt.html.subtitle>Please confirm ALL 4 options.</x-nymt.html.subtitle>
                    
                <x-nymt.input.checkboxform class="required" id="safeguarding_protect" wire:model.live="form.children" value="safeguarding_protect" label="I understand my legal responsibility to protect children from abuse and to promote their welfare."></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform class="required" id="safeguarding_report" wire:model.live="form.children" value="safeguarding_report" label="I understand that I have a responsibility to report to NYMT staff anything that concerns me about a child's welfare."></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform class="required" id="safeguarding_respect" wire:model.live="form.children" value="safeguarding_respect" label="I commit to helping to ensure children around me at NYMT feel safe, secure, valued and respected."></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform class="required" id="safeguarding_legal" wire:model.live="form.children" value="safeguarding_legal" label="I confirm that I have not been subject to a referral, caution or conviction that makes me unsuitable to attend a course alongside children, and I understand that any such information discovered by NYMT subsequent to my acceptance of this offer may be referred to the police as a possible criminal offence."></x-nymt.input.checkboxform>

                    
                @else 
                    
                <x-nymt.html.subtitle>Under 18s</x-nymt.html.subtitle>
                <p class="text-sm">You will be under 18 throughout the project.</p>
                <br>
                    
                    @if ($course->residential >0) 
                    <p class="text-sm">Please read our <a href="https://nymt.org.uk/site/assets/files/1573/nymt-guide-for-parents-2025.pdf" target='_blank' style='font-weight: bold; text-decoration: underline; position: relative;'>information for parents</a>.</p>
                    <br>
                    
                    <x-nymt.input.checkboxform class="required" name="form.residential" wire:model.live="form.residential" value="1" label="I understand that this is a fully residential course suitable for children aged 10 and over, and I have read <a href='https://nymt.org.uk/site/assets/files/1573/nymt-guide-for-parents-2025.pdf' target='_blank'>'The Residential Experience: Information for Parents'.</a>"></x-nymt.input.checkboxform>
                    
                    @endif
                    
                @endif
                <x-nymt.html.subtitle>Language and Content</x-nymt.html.subtitle>
                <x-nymt.input.checkboxform name="form.language_disclaimer" wire:model.live="form.language_disclaimer" value="1" label="I understand that NYMT projects may contain language and themes of a challenging nature."></x-nymt.input.checkboxform>
                    
                    
                <x-nymt.html.subtitle>Fees</x-nymt.html.subtitle>
                
                <x-nymt.input.checkboxform name="casting_fee" wire:model.live="form.casting_fee" value="1" label="I have read and agree to the <a href='https://nymt.org.uk/terms-and-conditions/' target='_blank' style='font-weight: bold; text-decoration: underline; position: relative;'>terms and conditions</a>."></x-nymt.input.checkboxform>
                
 
                <div class="text-center">
                <x-nymt.button @click="select('tab-1-3')" class="text-center">Back</x-nymt.button>
                <div wire:loading.delay class="inline-flex pl-4 pr-4">
                    <svg class="animate-spin h-5 w-5 text-black" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                </div>
                <x-nymt.button wire:click="validateStep(4)" class="text-center">Next</x-nymt.button>
                </div>
            </x-nymt.tabs.section> 
 
            <x-nymt.tabs.section class="p-1">   
                <x-nymt.html.subtitle>5: Emergency Contact Information</x-nymt.html.subtitle>
                <x-nymt.input.text class="required" label="Emergency Contact Name" placeholder="Enter Emergency Contact Name" wire:model.live="form.emergency_contact"></x-nymt.input.text>
                @error('form.emergency_contact')  <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text class="required" label="Relationship to You" placeholder="Enter Emergency Contact Relationship" wire:model.live="form.emergency_relationship" infotext="e.g. 'Mother'"></x-nymt.input.text>
                @error('form.emergency_relationship')  <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text class="required" label="Emergency Tel" placeholder="Enter Emergency Tel" wire:model.live="form.emergency_tel"></x-nymt.input.text>
                @error('form.emergency_tel')  <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                
                <x-nymt.html.subtitle>Please give us a Second Emergency Contact Information</x-nymt.html.subtitle>
                <x-nymt.input.text class="required" label="Second Emergency Contact Name" placeholder="Enter Second Emergency Contact Name" wire:model.live="form.emergency_2_contact"></x-nymt.input.text>
                @error('form.emergency_2_contact')  <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text class="required" label="Relationship to you" placeholder="Enter Second Emergency Contact Relationship" wire:model.live="form.emergency_2_relationship" infotext="e.g. 'Mother'"></x-nymt.input.text>
                @error('form.emergency_2_relationship')  <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text class="required" label="Second Emergency Tel" placeholder="Enter Second Emergency Tel" wire:model.live="form.emergency_2_tel"></x-nymt.input.text>
                @error('form.emergency_2_tel')  <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror



                <div class="text-center">
                <x-nymt.button @click="select('tab-1-4')" class="text-center">Back</x-nymt.button>
                <div wire:loading.delay class="inline-flex pl-4 pr-4">
                    <svg class="animate-spin h-5 w-5 text-black" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                </div>
                <x-nymt.button wire:click="validateStep(5)" class="text-center">Next</x-nymt.button>
                </div>
            </x-nymt.tabs.section> 

            <x-nymt.tabs.section class="p-1">   
                <x-nymt.html.subtitle>6. Permissions for Leaving Site</x-nymt.html.subtitle>
                    <p class="text-sm pb-2">Regardless of your age, you must seek permission from pastoral staff to go off site and must sign out and back in every time.</p>

                    <p class="text-sm pb-2">The Pastoral Lead will set appropriate limits on supervision and unaccompanied time based on location and other factors. These limits will not be less strict than those listed below, but may be more strict if deemed appropriate. Those under the age of 18 are not permitted to be unaccompanied after sunset.</p>

                    <p class="text-sm pb-2">Under 16s (school residences): Must be in groups of at least three, and will be familiarised with the area by staff.<br />
                        Under 16s (elsewhere): Must be accompanied by a member of staff.<br />
                        16s and 17s: Must be in groups of at least two.<br />
                        18s and older: May be solo, but we encourage at least pairs.</p>

                        <p class="text-sm pb-2">Children under 16 must depart residential stays with a parent or carer, except where permission for alternative arrangements has been given in writing.</p>
                
                @if ($form->ageAtDate($course->end_date) > 17)
                <x-nymt.input.checkboxform name="form.casting_offsite" wire:model="form.casting_offsite" value="1" label="I have read the policy above and agree to it."></x-nymt.input.checkboxform>
                
                @else
                
                <x-nymt.input.radio name="form.casting_offsite" wire:model="form.casting_offsite" value="1" label="I have read the policy above and agree to it."></x-nymt.input.radio>
                <x-nymt.input.radio name="form.casting_offsite" wire:model="form.casting_offsite" value="0" label="I do not agree. My child must always be accompanied by a member of pastoral staff."></x-nymt.input.radio>
                @endif
                <div class="text-center">
                <x-nymt.button @click="select('tab-1-5')" class="text-center">Back</x-nymt.button>
                <div wire:loading.delay class="inline-flex pl-4 pr-4">
                    <svg class="animate-spin h-5 w-5 text-black" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                </div>
                <x-nymt.button wire:click="validateStep(6)" class="text-center">Next</x-nymt.button>
                </div>
            </x-nymt.tabs.section> 
 
            <x-nymt.tabs.section class="p-1">   
                <x-nymt.html.subtitle>7. Medical Information</x-nymt.html.subtitle>
                <p class="text-sm pb-2">This information allows us to provide you with the best possible care. In addition to the information we request below, you are welcome to contact us confidentially to discuss your needs at <a href="mailto: pastoral@nymt.org.uk">pastoral@nymt.org.uk</a>.</p>

                <p class="text-sm pb-2">This section is to be filled in by a parent or carer where the child is under 16. Those over 16 may fill in this section themselves, but please read all information on the form before deciding.</p>

                <p class="text-sm pb-2">This information will be kept confidential but may be disclosed to relevant professionals if it is necessary to safeguard or promote the welfare of the participant or other members of the NYMT community.</p>

                <x-nymt.html.subtitle>Sex at Birth</x-nymt.html.subtitle>
                
                <p class="text-sm">We ask this so that we can fulfil our legal safeguarding duties.</p>
                <x-nymt.input.radio name="form.birth_gender" wire:model="form.birth_gender" value="male" label="Male"></x-nymt.input.radio>
                <x-nymt.input.radio name="form.birth_gender" wire:model="form.birth_gender" value="female" label="Female"></x-nymt.input.radio>

                <x-nymt.html.subtitle>Please tell us if you have recently experienced or are experiencing any of the following</x-nymt.html.subtitle>
                <x-nymt.input.checkboxform name="form.medical_info[]" wire:model="form.medical_info" value="Arm or leg problems" label="Arm or leg problems, including but not limited to fractures, tendon, ligament or cartilage damage"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.medical_info[]" wire:model="form.medical_info" value="Asthma, bronchitis or shortness of breath" label="Asthma, bronchitis or shortness of breath"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.medical_info[]" wire:model="form.medical_info" value="Blackouts or fainting" label="Blackouts or fainting"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.medical_info[]" wire:model="form.medical_info" value="Blood disorder" label="Blood disorder"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.medical_info[]" wire:model="form.medical_info" value="Bowel or urinary disorder" label="Bowel or urinary disorder"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.medical_info[]" wire:model="form.medical_info" value="Diabetes" label="Diabetes"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.medical_info[]" wire:model="form.medical_info" value="Hearing loss or problems with balance" label="Hearing loss or problems with balance"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.medical_info[]" wire:model="form.medical_info" value="Epilepsy, seizures or convulsions" label="Epilepsy, seizures or convulsions"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.medical_info[]" wire:model="form.medical_info" value="Mental health illness" label="Mental health illness, including but not limited to anxiety, depression or eating disorders"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.medical_info[]" wire:model="form.medical_info" value="Recent or recurring injury" label="Recent or recurring injury"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.medical_info[]" wire:model="form.medical_info" value="Recent surgery" label="Recent surgery"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.medical_info[]" wire:model="form.medical_info" value="Severe allergic reaction" label="Severe allergic reaction"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.medical_info[]" wire:model="form.medical_info" value="Sleeping issues" label="Sleeping issues, including but not limited to sleepwalking"></x-nymt.input.checkboxform>
                
                <p class="text-sm pb-2">If you ticked any of the boxes above, please give us more information. There will be the opportunity to tell us about any other medical issues later on.</p>
                <x-nymt.input.textarea label="More Information" infotext="Tell us more about any selections you've made above." wire:model="form.medical_more_info" rows="4" maxlength="1000"></x-nymt.input.textarea>
                <x-nymt.input.textarea label="Other Medical Conditions" infotext="Please let us know if you have any other medical conditions that you think we should know about, or if you take regular medication. Ensure that an adequate supply of any regular medication is brought to the course. Pastoral staff are able to supervise regular medication requirements for children if required; please provide clear instructions." wire:model="form.medical_info_other" rows="4" placeholder="If none, leave this box empty." maxlength="1000"></x-nymt.input.textarea>
                
                
                @if ($course->residential >0) 
                <x-nymt.html.subtitle>Homesickness</x-nymt.html.subtitle>
                <p class="text-sm pb-2">Please tick below if you (/your child) might find staying away from home particularly challenging.</p>

                <p class="text-sm pb-2">NYMT has a team of pastoral staff with significant experience of working in boarding and in supporting children with homesickness. It is extremely rare that homesickness presents a significant problem to children at NYMT beyond the first couple of days, even for those with little or no experience of being away from home. </p>

                <p class="text-sm pb-2">We encourage you to speak to the pastoral staff on arrival if you believe that homesickness may be a challenge.</p>
                <x-nymt.input.checkboxform name="form.homesickness" value="1" label="Yes, I think that homesickness may be a challenge"></x-nymt.input.checkboxform>
                <x-nymt.html.subtitle>Dietary Requirements</x-nymt.html.subtitle>
                <x-nymt.input.checkboxform name="form.dietry[]" wire:model="form.dietry" value="Dairy/lactose free" label="Dairy/lactose free"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.dietry[]" wire:model="form.dietry" value="Egg allergy or intolerance" label="Egg allergy or intolerance"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.dietry[]" wire:model="form.dietry" value="Gluten free" label="Gluten free"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.dietry[]" wire:model="form.dietry" value="Halal" label="Halal"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.dietry[]" wire:model="form.dietry" value="Kosher" label="Kosher"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.dietry[]" wire:model="form.dietry" value="Nut allergy or intolerance" label="Nut allergy or intolerance"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.dietry[]" wire:model="form.dietry" value="Pescatarian" label="Pescatarian"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.dietry[]" wire:model="form.dietry" value="Shellfish allergy or intolence" label="Shellfish allergy or intolence"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.dietry[]" wire:model="form.dietry" value="Vegan" label="Vegan"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.dietry[]" wire:model="form.dietry" value="Vegetarian" label="Vegetarian"></x-nymt.input.checkboxform>
                @endif
                
                <x-nymt.input.textarea label="Allergy Information" wire:model="form.pastoral_allergies" infotext="Tell us about any allergies you have. Please include usual treatment." rows="4" placeholder="If none, leave this box empty." maxlength="1000"></x-nymt.input.textarea>
                <x-nymt.input.select label="I use an Adrenaline Auto Injector (Epipen or similar)" model="form.pastoral_epipen" infotext="If you select yes, please bring two if you have two and make yourself known to staff on arrival.">
                    <x-nymt.options.yesno></x-nymt.options.yesno>
                </x-nymt.input.select>
                <x-nymt.input.select label="I use an inhaler" model="form.pastoral_inhaler" infotext="If you select yes, please bring a spare.">
                    <x-nymt.options.yesno></x-nymt.options.yesno>
                </x-nymt.input.select>
                
                <x-nymt.input.textarea label="Accessibility" wire:model="form.pastoral_barriers" rows="4" infotext="We strive to make NYMT somewhere that is inclusive and accessible for all. If you have accessibility needs, please let us know here." placeholder="If none, leave this box empty." maxlength="1000"></x-nymt.input.textarea>
              
                <x-nymt.input.select label="Disability" model="form.pastoral_disability" infotext="Do you have a disability in accordance with the terms of the Disability Discrimination Act 2005?">
                    <x-nymt.options.yesno></x-nymt.options.yesno>
                </x-nymt.input.select>
                
                <x-nymt.html.subtitle class="required">Medical Consent</x-nymt.html.subtitle>
                <p class="text-sm pb-2">Pastoral Staff are authorised to treat minor ailments as follows, where allergies permit:
                <ul class="text-sm p-4 list-disc">
                    <li>headaches or backaches with drinks of water and rest, with paracetamol if deemed necessary;</li>
                    <li>wasp stings and insect bites with over-the-counter antihistamine cream; </li>
                    <li>hay fever, where there is no prescribed remedy, with over-the counter antihistamine;</li>
                    <li>cuts and scrapes with an antiseptic wipe and a plaster; </li>
                    <li>bruises with arnica cream and/or cold pads;</li>
                    <li>indigestion with over-the counter indigestion tablets.</li>
                </ul>
                <p class="text-sm pb-2">Please see the <a href="https://nymt.org.uk/safeguarding-policy/">First Aid & Medical Policy</a> on our website for more information about how we deal with medical emergencies.</p> 

                <p class="text-sm pb-2"><b>Information on Consent to Medical Treatment</b></p>
                <p class="text-sm pb-2">Adults, defined as people of 18 and over, are usually regarded as competent to decide their own treatment. The Family Law Reform Act 1969 also gives the right to consent to treatment to anyone aged 16 to 18. Young people under the age of 16 can consent to medical treatment if they have sufficient maturity and judgement to enable them to give informed consent.</p>
                <x-nymt.input.radio name="form.consent" wire:model.live="form.consent" value="agree" label="I agree to the policies set out above and in the First Aid & Medical Policy."></x-nymt.input.radio>
                <x-nymt.input.radio name="form.consent" wire:model.live="form.consent" value="agree_exceptions" label="I agree to the policies set out above and in the First Aid & Medical Policy, with exceptions listed below."></x-nymt.input.radio>
    
                @if ($form->consent == "agree_exceptions")
                <x-nymt.input.textarea label="Exceptions to Medical Consent" infotext="Please detail any exceptions to medical consent." wire:model="form.consent_exceptions" rows="4" maxlength="1000"></x-nymt.input.textarea>
 
                @endif
                <div class="text-center">
                <x-nymt.button @click="select('tab-1-6')" class="text-center">Back</x-nymt.button>
                <div wire:loading.delay class="inline-flex pl-4 pr-4">
                    <svg class="animate-spin h-5 w-5 text-black" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                </div>
                <x-nymt.button wire:click="validateStep(7)" class="text-center">Next</x-nymt.button>
                </div>
            </x-nymt.tabs.section> 
            <x-nymt.tabs.section class="p-1">   
                <x-nymt.html.subtitle>Course Application</x-nymt.html.subtitle>
                
                <x-nymt.input.text class="required" label="Signed" infotext="Please enter your full name as your signature." wire:model.live="form.casting_accept"></x-nymt.input.text>
                
                
                <x-nymt.button wire:click="save()" class="text-center">Send</x-nymt.button>
                <div wire:loading.delay  wire:target="save" class="inline-flex pl-4 pr-4">
                    <svg class="animate-spin h-5 w-5 text-black" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                </div>
            </x-nymt.tabs.section> 
            @endif
        </x-slot>
    </x-nymt.tabs.alt> 
    </form>
</div>   
    </div>
    </x-nymt.body>