    <div class="">
        <div class="relative sm:flex sm:justify-center sm:items-center min-h-screen bg-dots-darker bg-center dark:bg-dots-lighter dark:bg-gray-900 selection:bg-red-500 selection:text-white">
            
            <div class="bg-white rounded-xl shadow p-8 flex flex-col gap-6 min-w-[35rem]">
                @if ($message = Session::get('success'))
            
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <strong>{{ $message }}</strong>
                </div>
                
                
                <div>
                    <p class="pb-2">Thank you for booking, {{ $ycm->firstname }}.</p>
                    <p class="pb-2">Please now check your email for further information.</p>
                
                
                    @if ($ycm->category != "cpp")
 
                    <x-nymt.html.subtitle>Audition Booked</x-nymt.html.subtitle>
                    <p class="pb-2">{{ $ycm->audition->venue_date->name }}, {{ date('l d F Y', strtotime($ycm->audition->venue_date->start_date)) }} | {{ $ycm->audition->venue_date->venue->town }}</p>
                
                    @endif    
                
                </div>


                <img src="/media/images/NYMT_Logo_Full_Colour.png" style="width:500px">


                @elseif ($message = Session::get('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <strong>{{ $message }}</strong>
                </div>
                
                @else    
                <div>
                    <p class="pb-2 text-2xl font-bold">Thanks! Please now click on the link below to pay.</p>

                    <p class="pb-2">Your application will not be completed until you have paid.</p>
    
                    <p class="pb-2">We look forward to meeting you!</p>

                    <center>
                        <x-nymt.button.primary wire:click="payment()">Pay with PayPal</x-nymt.button.primary>
                    </center>
                </div>
                @endif

            </div>
        </div>
    </div>