<div class="w-full mx-4 mt-10 bg-white p-6 rounded shadow">
    <h1 class="text-2xl font-semibold mb-4">Welcome {{ $parent->firstname }} {{ $parent->lastname }}</h1>

    <p class="mb-2"><strong>Guardian / Account Email:</strong> {{ $parent->email }}</p>

    <h2 class="text-lg font-bold mt-6">Linked Young Cast members</h2>
    
            <x-nymt.table>
                
                <x-slot name="head">
                    
                        <x-nymt.table.heading>Name</x-nymt.table.heading>
                        <x-nymt.table.heading>Email</x-nymt.table.heading>
                        <x-nymt.table.heading>Auditions</x-nymt.table.heading>
                        <x-nymt.table.heading>Courses</x-nymt.table.heading>
                        <x-nymt.table.heading class="text-center">Actions</x-nymt.table.heading>

                </x-slot>

                <x-slot name="body">

                @foreach ($parent->auditionees as $auditionee)
                    
                    <x-nymt.table.row>

                        <x-nymt.table.cell>{{ $auditionee->firstname }} {{ $auditionee->lastname }}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{ $auditionee->email }}</x-nymt.table.cell>
                        
                        @if (count($auditionee->auditions) > 0)
                            <x-nymt.table.cell>
                            @foreach($auditionee->auditions as $audition)
                                {{ $audition->venue_date->venue->name}} - {{ $audition->venue_date->name}} - {{  date('Y-m-d' , strtotime($audition->venue_date->start_date)) }}<br />
                            @endforeach    
                            </x-nymt.table.cell>  
                        @else
                            <x-nymt.table.cell>
                                    <b>No Auditions Yet</b>
                            </x-nymt.table.cell>  
                        @endif
                        
                        @if (count($auditionee->courses) > 0)
                            <x-nymt.table.cell>
                            @foreach($auditionee->courses as $course)
                                {{ $course->course->name}} - {{ $course->course->location}} - {{  date('Y-m-d' , strtotime($course->course->start_date)) }}<br />
                            @endforeach    
                            </x-nymt.table.cell>  
                        @else
                             <x-nymt.table.cell>
                                    <b>No Courses Yet</b>
                             </x-nymt.table.cell>  
                        @endif
                        
                        
                        <x-nymt.table.cell class="text-center">
                            
                            <div class="flex">
                              <div class="flex-none">
                                  <x-nymt.button.primarylink href="#" wire:click="newAudition({{ $auditionee->id }})">New Audition</x-nymt.button.primarylink>
                              </div>
                              <div class="flex-none">
                                  <x-nymt.button.primarylink href="#" wire:click="newCourse({{ $auditionee->id }})">New Course</x-nymt.button.primarylink>
                              </div>
                            </div>
                        </x-nymt.table.cell>
                    </x-nymt.table.row>

                    @endforeach

                </x-slot>

            </x-nymt.table>
            
            <h2 class="text-lg font-bold mt-6">Add a New Young Cast members</h2>
            <div class="flex">
              <div class="flex-none">
                    <x-nymt.button.primarylink href="#" wire:click="newAudition()">New Audition</x-nymt.button.primarylink>
              </div>
              <div class="flex-none">
                    <x-nymt.button.primarylink href="#" wire:click="newCourse()">New Course</x-nymt.button.primarylink>
              </div>
            </div>
    
    
</div>
