   <x-slot name="header">
    <div class="flex">
        
    <div>
    <x-nymt.html.title>
        {{ $this->crud }} YCM
        @if ($form->auditionee_id) 
        - {{ $form->auditionee->firstname }} {{ $form->auditionee->lastname }}  <span class="text-xs">({{ $form->auditionee->age() }}yrs)</span>
        @endif
    </x-nymt.html.title>
    </div>
    
    <div class="md:text-center grow">
    
        @if ($form->auditionee_id) 
        @foreach($form->auditionee->tags() as $key => $tag)
        <x-nymt.html.tag tagType="{{ $key }}">{{ $tag }}</x-nymt.html.tag>
        @endforeach
        @endif
    </div>
    
    </div>

    </x-slot>

    <x-nymt.body>

    <div class="grid grid-cols-1">

        
    <div>  
    <form wire:submit="save">
    <x-nymt.tabs>
        <x-slot name="head">
            <x-nymt.tabs.label>Details</x-nymt.tabs.label>
            @if ($form->auditionee_id) 
            <x-nymt.tabs.label>Experience</x-nymt.tabs.label>
            <x-nymt.tabs.label>Pastoral Info</x-nymt.tabs.label>
            <x-nymt.tabs.label>NYMT Experience</x-nymt.tabs.label>
            <x-nymt.tabs.label>Casting Info</x-nymt.tabs.label>
            <x-nymt.tabs.label>Transactions</x-nymt.tabs.label>
            @endif
        </x-slot>

        <x-slot name="body">      
            <x-nymt.tabs.section>   
                <x-nymt.input.text class="required" leadingAddOn="Firstname" placeholder="Enter Firstname" wire:model.blur="form.firstname"></x-nymt.input.text>
                @error('form.firstname')  <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text class="required" leadingAddOn="Lastname" placeholder="Enter Lastname" wire:model.blur="form.lastname"></x-nymt.input.text>
                @error('form.lastname')  <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text leadingAddOn="Formal Name" placeholder="Enter Formal Name" wire:model.blur="form.formalname"></x-nymt.input.text>
                @error('form.formalname')  <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text class="required" leadingAddOn="Email" placeholder="Enter Email" wire:model.blur="form.email"></x-nymt.input.text>
                @error('form.email')  <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text class="required" leadingAddOn="Secondary Email" placeholder="Enter Email" wire:model.blur="form.secondary_email"></x-nymt.input.text>
                @error('form.secondary_email')  <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.select notlive class="required" model="form.gender" leadingAddOn="Gender">
                <option value="" selected>Choose your Gender</option>
                <x-nymt.options.gender></x-nymt.options.gender>
                </x-nymt.input.select>
                @error('form.gender') <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text class="required" leadingAddOn="Date of Birth" placeholder="Enter Date of Birth" wire:model.blur="form.dob" type="date"></x-nymt.input.text>
                @error('form.dob') <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
            
                
                <x-nymt.input.text leadingAddOn="Contact Tel" placeholder="Enter Contact Tel" wire:model.blur="form.tel"></x-nymt.input.text>
                @error('form.tel')  <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                
                
                
                <x-nymt.input.text leadingAddOn="Emergency Contact Name" placeholder="Enter Emergency Contact Name" wire:model.blur="form.emergency_contact"></x-nymt.input.text>
                @error('form.emergency_contact')  <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text leadingAddOn="Emergency Contact Relationship" placeholder="Enter Emergency Contact Relationship" wire:model.blur="form.emergency_relationship"></x-nymt.input.text>
                @error('form.emergency_relationship')  <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                
                <x-nymt.input.text leadingAddOn="Emergency Tel" placeholder="Enter Emergency Tel" wire:model.blur="form.emergency_tel"></x-nymt.input.text>
                @error('form.emergency_tel') <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                
                <x-nymt.input.text leadingAddOn="Street Address" placeholder="Enter Street Address" wire:model.blur="form.address"></x-nymt.input.text>
                @error('form.address') <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                
                <x-nymt.input.text leadingAddOn="Town / City" placeholder="Enter Town / City" wire:model.blur="form.town"></x-nymt.input.text>
                @error('form.town') <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                
                <x-nymt.input.text leadingAddOn="Post Code" placeholder="Enter Post Code" wire:model.blur="form.postcode"></x-nymt.input.text>
                @error('form.postcode') <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror

                <x-nymt.input.select notlive leadingAddOn="Country" model="form.country">
                <option value="" selected>Choose your country</option>

                @foreach (App\Enums\Country::cases() as $country)
                    <option value="{{ $country->value }}">{{ $country->label() }}</option>
                @endforeach
                </x-nymt.input.select>
                @error('form.country')   <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                
            </x-nymt.tabs.section>  
        
            @if ($form->auditionee_id) 
            <x-nymt.tabs.section> 

                <x-nymt.input.select leadingAddOn="Category" model="form.category">
                <option value="" selected>Choose your category</option>
                    <x-nymt.options.categories></x-nymt.options.categories>
                </x-nymt.input.select>
                
                
                @if ($form->category == "cpp")
                <x-nymt.input.select notlive leadingAddOn="Role" model="form.nymt_role">
                    <option value="" selected>Choose Role</option>
                    <x-nymt.options.nymt_ctms></x-nymt.options.nymt_ctms>
                </x-nymt.input.select>
                @endif 
                
                <x-nymt.input.select notlive class="required" label="Voice" infotext="Which voice part best describes your range?" model="form.singing_experience">
                    <option value="" selected>Choose your Range</option>
                    <x-nymt.options.singing_experience></x-nymt.options.singing_experience>
                </x-nymt.input.select>
                
                <x-nymt.input.select notlive label="Dance" infotext="Do you have experience in any of the following? Please tick all that apply." model="form.dancing_experience" multiple >
                    <x-nymt.options.dancing_experience></x-nymt.options.dancing_experience>
                </x-nymt.input.select>
                <x-nymt.input.text label="Dance Skill Level" textinfo="If you selected any of the optoins above, please enter RAD / ISTD / IDTA skill or grade level attained, if known, here." wire:model.blur="form.dance_skill_level"></x-nymt.input.text>
                <x-nymt.input.textarea label="Musical Instruments" textinfo="Please tell us about any musical instruments you play. If none, leave box empty." wire:model.blur="form.musical_instruments"></x-nymt.input.textarea>
                <x-nymt.input.textarea label="Previous Performance Experience" infotext="Tell us briefly about any relevant performance experience you have. If none, leave box empty." wire:model="form.acting_experience" rows="4"></x-nymt.input.textarea>
                <x-nymt.input.textarea label="Special Skills" textinfo="Do you have any special skills, e.g. circus skills or martial arts? Please give details & skill level. If none, leave box empty." wire:model.blur="form.special_skills"></x-nymt.input.textarea>
            </x-nymt.tabs.section>  
            <x-nymt.tabs.section> 
            <x-nymt.html.subtitle>Pastoral Information</x-nymt.html.subtitle>
            
            <x-nymt.input.select notlive leadingAddOn="Epipen User" model="form.pastoral_epipen">
                <x-nymt.options.yesno></x-nymt.options.yesno>
            </x-nymt.input.select>
            <x-nymt.input.select notlive leadingAddOn="Inhaler User" model="form.pastoral_inhaler">
                <x-nymt.options.yesno></x-nymt.options.yesno>
            </x-nymt.input.select>
            
                <x-nymt.input.textarea label="Barriers to Participation" wire:model="form.pastoral_barriers" rows="4" infotext="If you have any potential barriers to participation that might affect your involvement, please enter them below.  If none, leave box empty."></x-nymt.input.textarea>
                
                <x-nymt.input.select notlive leadingAddOn="Disability" model="form.pastoral_disability" infotext="Do you have a disability in accordance with the terms of the Disability Discrimination Act 2005?">
                    <x-nymt.options.yesno></x-nymt.options.yesno>
                </x-nymt.input.select>
            <x-nymt.input.textarea label="Allergy information" wire:model="form.pastoral_allergies" rows="4"></x-nymt.input.textarea>
            </x-nymt.tabs.section> 
            <x-nymt.tabs.section>    
                <x-nymt.input.select notlive class="required" label="Have you taken part in an NYMT project before?" model="form.nymt_experience" >
                    <option value="" selected>Please Choose</option>
                    <x-nymt.options.nymt_experience></x-nymt.options.nymt_experience>
                </x-nymt.input.select>
                @if ($form->nymt_experience == 0)
                <x-nymt.input.select notlive label="How did you hear about NYMT?" model="form.nymt_experience_no" textinfo="How did you first hear about NYMT">
                    <option value="" selected>Please Choose</option>
                    <x-nymt.options.nymt_experience_no></x-nymt.options.nymt_experience_no>
                </x-nymt.input.select>
                @if ($form->nymt_experience_no == 'Other')
                <x-nymt.input.text leadingAddOn="Other" placeholder="Enter Other" wire:model.blur="form.nymt_experience_no_other"></x-nymt.input.text>
                @endif
                @endif
                
                @if ($form->nymt_experience != '0')
                <x-nymt.input.textarea label="What projects have you been involved in with NYMT?" wire:model="form.nymt_experience_yes" rows="4"></x-nymt.input.textarea>
                @endif
                
                <x-nymt.input.textarea label="Availability issues" placeholder="" wire:model.blur="form.unavailability" infotext="If none, leave box empty."></x-nymt.input.textarea>
                
                <x-nymt.input.select notlive class="required" model="form.film_permission" label="Filming & Photography Permission" >
                <option value="" selected>Choose</option>
                <option value="1">I agree</option>
                <option value="2">Other</option>
                </x-nymt.input.select>
                
                @if ($form->film_permission == '2')
                <x-nymt.input.text label="Other" placeholder="Tell us about any exceptions to the permission above" wire:model.blur="form.film_permission_other"></x-nymt.input.text>
                @endif
                
                <x-nymt.input.select notlive model="form.ethnicity" leadingAddOn="Ethnicity">
                <option value="" selected>Choose your Ethnicity</option>
                <x-nymt.options.ethnicity></x-nymt.options.ethnicity>
                </x-nymt.input.select>
                
                <x-nymt.input.textarea label="Education" placeholder="Your school, college or university" wire:model.blur="form.education" infotext="Please enter the name and address"></x-nymt.input.textarea>
                @error('form.education') <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                
                
                <x-nymt.input.select notlive model="form.education_type" leadingAddOn="Current education">
                <option value="" selected>Choose your Current education</option>
                <x-nymt.options.education_type></x-nymt.options.education_type>
                </x-nymt.input.select>
                
                <x-nymt.input.select notlive class="required" leadingAddOn="Emails from NYMT" model="form.marketing_emails">
                    <option value="" selected>Please select an option</option>
                    <x-nymt.options.yesno></x-nymt.options.yesno>
                </x-nymt.input.select>
                
                <x-nymt.input.select notlive class="required" leadingAddOn="Terms and Conditions" model="form.marketing_terms">
                    <option value="" selected>Please select an option</option>
                    <x-nymt.options.yesno></x-nymt.options.yesno>
                </x-nymt.input.select>
                
            </x-nymt.tabs.section> 
            <x-nymt.tabs.section> 
                <x-nymt.html.subtitle>Course/Casting Information</x-nymt.html.subtitle>
                <x-nymt.input.select notlive leadingAddOn="The Residential Experience" model="form.casting_residential">
                    <x-nymt.options.yesno></x-nymt.options.yesno>
                </x-nymt.input.select>
                
                
                <x-nymt.input.checkboxform class="required" id="safeguarding_protect" wire:model.live="form.casting_children" value="safeguarding_protect" label="I understand my legal responsibility to protect children from abuse and to promote their welfare."></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform class="required" id="safeguarding_report" wire:model.live="form.casting_children" value="safeguarding_report" label="I understand that I have a responsibility to report to NYMT staff anything that concerns me about a child's welfare."></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform class="required" id="safeguarding_respect" wire:model.live="form.casting_children" value="safeguarding_respect" label="I commit to helping to ensure children around me at NYMT feel safe, secure, valued and respected."></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform class="required" id="safeguarding_legal" wire:model.live="form.casting_children" value="safeguarding_legal" label="I confirm that I have not been subject to a referral, caution or conviction that makes me unsuitable to attend a course alongside children, and I understand that any such information discovered by NYMT subsequent to my acceptance of this offer may be referred to the police as a possible criminal offence."></x-nymt.input.checkboxform>

                
                <x-nymt.input.select notlive leadingAddOn="Language and Content" model="form.casting_language_disclaimer">
                    <x-nymt.options.yesno></x-nymt.options.yesno>
                </x-nymt.input.select>
                <x-nymt.input.select notlive leadingAddOn="Parental permission for leaving site" model="form.casting_offsite">
                    <x-nymt.options.yesno></x-nymt.options.yesno>
                </x-nymt.input.select>
                
                <x-nymt.html.subtitle>Please tell us if you have recently experienced or are experiencing any of the follow</x-nymt.html.subtitle>
                <x-nymt.input.checkboxform name="form.medical_info[]" wire:model="form.casting_medical_info" value="Arm or leg problems" label="Arm or leg problems, including but not limited to fractures, tendon, ligament or cartilage damage"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.medical_info[]" wire:model="form.casting_medical_info" value="Asthma, bronchitis or shortness of breath" label="Asthma, bronchitis or shortness of breath"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.medical_info[]" wire:model="form.casting_medical_info" value="Blackouts or fainting" label="Blackouts or fainting"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.medical_info[]" wire:model="form.casting_medical_info" value="Blood disorder" label="Blood disorder"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.medical_info[]" wire:model="form.casting_medical_info" value="Bowel or urinary disorder" label="Bowel or urinary disorder"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.medical_info[]" wire:model="form.casting_medical_info" value="Diabetes" label="Diabetes"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.medical_info[]" wire:model="form.casting_medical_info" value="Hearing loss or problems with balance" label="Hearing loss or problems with balance"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.medical_info[]" wire:model="form.casting_medical_info" value="Epilepsy, seizures or convulsions" label="Epilepsy, seizures or convulsions"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.medical_info[]" wire:model="form.casting_medical_info" value="Mental health illness" label="Mental health illness, including but not limited to anxiety, depression or eating disorders"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.medical_info[]" wire:model="form.casting_medical_info" value="Recent or recurring injury" label="Recent or recurring injury"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.medical_info[]" wire:model="form.casting_medical_info" value="Recent surgery" label="Recent surgery"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.medical_info[]" wire:model="form.casting_medical_info" value="Severe allergic reaction" label="Severe allergic reaction"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.medical_info[]" wire:model="form.casting_medical_info" value="Sleeping issues" label="Sleeping issues, including but not limited to sleepwalking"></x-nymt.input.checkboxform>
                <x-nymt.input.text leadingAddOn="Medical Conditions: More Information" placeholder="More Information" wire:model.blur="form.casting_medical_more_info"></x-nymt.input.text>
                <x-nymt.input.text leadingAddOn="Medical Conditions: Other Information" placeholder="Other Information" wire:model.blur="form.casting_medical_info_other"></x-nymt.input.text>
                                <x-nymt.html.subtitle>Dietary requirements</x-nymt.html.subtitle>
                <x-nymt.input.checkboxform name="form.dietry[]" wire:model="form.casting_dietry" value="Dairy/lactose free" label="Dairy/lactose free"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.dietry[]" wire:model="form.casting_dietry" value="Egg allergy or intolerance" label="Egg allergy or intolerance"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.dietry[]" wire:model="form.casting_dietry" value="Gluten free" label="Gluten free"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.dietry[]" wire:model="form.casting_dietry" value="Halal" label="Halal"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.dietry[]" wire:model="form.casting_dietry" value="Kosher" label="Kosher"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.dietry[]" wire:model="form.casting_dietry" value="Nut allergy or intolerance" label="Nut allergy or intolerance"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.dietry[]" wire:model="form.casting_dietry" value="Pescatarian" label="Pescatarian"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.dietry[]" wire:model="form.casting_dietry" value="Shellfish allergy or intolence" label="Shellfish allergy or intolence"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.dietry[]" wire:model="form.casting_dietry" value="Vegan" label="Vegan"></x-nymt.input.checkboxform>
                <x-nymt.input.checkboxform name="form.dietry[]" wire:model="form.casting_dietry" value="Vegetarian" label="Vegetarian"></x-nymt.input.checkboxform>
                <x-nymt.input.text leadingAddOn="Emergency Contact Name Alt" placeholder="Enter Emergency Contact Name" wire:model.blur="form.emergency_2_contact"></x-nymt.input.text>
                @error('form.emergency_2_contact')  <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text leadingAddOn="Emergency Contact Relationship Alt" placeholder="Enter Emergency Contact Relationship" wire:model.blur="form.emergency_2_relationship"></x-nymt.input.text>
                @error('form.emergency_2_relationship')  <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                <x-nymt.input.text leadingAddOn="Emergency Tel Alt" placeholder="Enter Emergency Tel Alt" wire:model.blur="form.emergency_2_tel"></x-nymt.input.text>
                @error('form.emergency_2_tel') <x-nymt.input.error>{{ $message }}</x-nymt.input.error> @enderror
                
                
                <x-nymt.input.select notlive leadingAddOn="Sex at birth" model="form.birth_gender">
                    <option value="" selected>Choose your Birth Sex</option>
                    <x-nymt.options.sex></x-nymt.options.sex>
                </x-nymt.input.select>
                <x-nymt.input.select notlive leadingAddOn="Immunisations" model="form.casting_immunisations">
                    <x-nymt.options.yesno></x-nymt.options.yesno>
                </x-nymt.input.select>
                <x-nymt.input.select notlive leadingAddOn="Homesickness" model="form.casting_homesickness">
                    <x-nymt.options.yesno></x-nymt.options.yesno>
                </x-nymt.input.select>
                
                
                <x-nymt.input.radio name="form.casting_consent" wire:model.blur="form.casting_consent" value="agree" label="I agree to the policies in the First Aid & Medical Policy."></x-nymt.input.radio>
                <x-nymt.input.radio name="form.casting_consent" wire:model.blur="form.casting_consent" value="agree_exceptions" label="I agree to the policies in the First Aid & Medical Policy, with exceptions listed below."></x-nymt.input.radio>
    
                @if ($form->casting_consent == "agree_exceptions")
                <x-nymt.input.textarea label="Exceptions to Medical Consent" infotext="Detail any Exceptions to Medical Consent." wire:model="form.casting_consent_exceptions" rows="4"></x-nymt.input.textarea>
 
                @endif
                
                
                <x-nymt.input.select notlive leadingAddOn="Fee Agreement" model="form.casting_fee">
                    <x-nymt.options.yesno></x-nymt.options.yesno>
                </x-nymt.input.select>
                <x-nymt.input.text  leadingAddOn="Offer Acceptance" placeholder="Enter Signature" wire:model.blur="form.casting_accept"></x-nymt.input.text>
                
            </x-nymt.tabs.section> 
            <x-nymt.tabs.section> 
            
                
            <x-nymt.table>

                <x-slot name="head">
                    
                        <x-nymt.table.heading>Date Created</x-nymt.table.heading>
                        <x-nymt.table.heading>Status</x-nymt.table.heading>
                        <x-nymt.table.heading>Amount</x-nymt.table.heading>

                </x-slot>

                <x-slot name="body">
                    @foreach($form->auditionee->transactions as $transaction)
                    <x-nymt.table.row>
                        <x-nymt.table.cell>{{ $transaction->created_at}}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{ $transaction->status}}</x-nymt.table.cell>
                        <x-nymt.table.cell>&pound; {{ $transaction->amount}}</x-nymt.table.cell>
                    
                    </x-nymt.table.row>
                    @endforeach
                </x-slot>

            </x-nymt.table>
            </x-nymt.tabs.section>  
            @endif
            
            <div class="text-center">
                <button type="submit" class="relative max-w-sm w-full bg-blue-500 py-3 px-8 rounded-lg text-white font-medium disabled:cursor-not-allowed disabled:opacity-75">
                Save

                <div wire:loading.flex wire:target="save" class="flex absolute top-0 right-0 bottom-0 flex items-center pr-4">
                    <svg class="animate-spin h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                </div>
                </button>
                </div>
        </x-slot>
    </x-nymt.tabs> 
    </form>
    </div>      
            
            

    </div>
    
    
    </x-nymt.body>