<div class="max-w-md mx-auto mt-10 bg-white p-6 rounded shadow">
    <h1 class="text-xl font-bold mb-4">Reset Your Password</h1>

    @if ($status)
        <div class="mb-4 p-2 text-green-600 bg-green-100 border border-green-300 rounded">
            {{ $status }}
        </div>
    @endif

    <form wire:submit.prevent="resetPassword">
        <div class="mb-4">
            <label for="email" class="block mb-1 font-medium">Email Address</label>
            <input
                wire:model="email"
                type="email"
                id="email"
                required
                class="w-full border border-gray-300 p-2 rounded focus:outline-none focus:ring-2 focus:ring-blue-500"
            />
            @error('email') <span class="text-red-600 text-sm">{{ $message }}</span> @enderror
        </div>

        <div class="mb-4">
            <label for="password" class="block mb-1 font-medium">New Password</label>
            <input
                wire:model="password"
                type="password"
                id="password"
                required
                class="w-full border border-gray-300 p-2 rounded focus:outline-none focus:ring-2 focus:ring-blue-500"
            />
            @error('password') <span class="text-red-600 text-sm">{{ $message }}</span> @enderror
        </div>

        <div class="mb-4">
            <label for="password_confirmation" class="block mb-1 font-medium">Confirm New Password</label>
            <input
                wire:model="password_confirmation"
                type="password"
                id="password_confirmation"
                required
                class="w-full border border-gray-300 p-2 rounded focus:outline-none focus:ring-2 focus:ring-blue-500"
            />
        </div>

        <button
            type="submit"
            class="w-full bg-blue-600 text-white py-2 rounded hover:bg-blue-700 transition"
        >
            Reset Password
        </button>
    </form>

    <div class="mt-4 text-center">
        <a href="{{ route('ycm.login') }}" class="text-blue-600 hover:underline text-sm">
            Back to login
        </a>
    </div>
</div>
