  <x-slot name="header">
    <div class="grid grid-cols-1 gap-4 md:grid-cols-3">
        
    <div>
    <x-nymt.html.title>
        {{ $this->crud }} Auditionee
        @if ($form->auditionee_id) 
        - {{ $form->auditionee->firstname }} {{ $form->auditionee->lastname }}  <span class="text-xs">({{ $form->auditionee->age() }}yrs)</span>
        @endif
    </x-nymt.html.title>
    </div>
    
    <div class="md:text-right">
    
        @if ($form->auditionee_id) 
        @foreach($form->auditionee->tags() as $key => $tag)
        <x-nymt.html.tag tagType="{{ $key }}">{{ $tag }}</x-nymt.html.tag>
        @endforeach
        @endif
    </div>
    
    <div class="md:text-right">
    Back to
    
        @if ($form->auditionee->audition) 
    <a class="group" href="/auditionees/audition-list/{{ $form->auditionee->audition->venue_date_id }}?view=list" title="View Auditionee List" alt="View Auditionee List">Auditionee List</a>
    |    
        @endif
    <a class="group" href="/auditionees/edit/{{ $form->auditionee->id }}" title="View Auditionee Profile" alt="View Auditionee Profile">View full profile</a> 

    </div>
    </x-slot>

    <x-nymt.body>

    <div class="">

             
            
    @if ($form->auditionee_id) 
    <div class="grid grid-cols-4 gap-2">
    <div class="col-span-3">
    <x-nymt.tabs>
        <x-slot name="head">
            <x-nymt.tabs.label>Audition: {{ $form->auditionee->audition->venue_date->venue->name }} - {{ $form->auditionee->audition->venue_date->name}} - {{  date('Y-m-d' , strtotime($form->auditionee->audition->venue_date->start_date)) }}</x-nymt.tabs.label>
        </x-slot>
        <x-slot name="body">  
        
            <x-nymt.tabs.section> 
            
            
            
            <x-nymt.html.subtitle>Audition Scores & Notes</x-nymt.html.subtitle>
            
                <x-nymt.table>

                <x-slot name="head">
                    
                        <x-nymt.table.heading>Acting</x-nymt.table.heading>
                        <x-nymt.table.heading></x-nymt.table.heading>
                        <x-nymt.table.heading>Music</x-nymt.table.heading>
                        <x-nymt.table.heading></x-nymt.table.heading>
                        <x-nymt.table.heading>Dance</x-nymt.table.heading>
                        <x-nymt.table.heading></x-nymt.table.heading>
                        <x-nymt.table.heading>OUTCOME</x-nymt.table.heading>

                </x-slot>

                <x-slot name="body">
                    <x-nymt.table.row>
                        
                        
                            @foreach($form->auditionee->auditions as $audition)
                        <x-nymt.table.cell> @livewire('component.edit-field',['id'=>$audition->id,'object'=>'AuditionScore','field'=>'acting_score', 'input' => 'score'], key(rand() * $audition->id))</x-nymt.table.cell>
                        <x-nymt.table.cell> @livewire('component.edit-field',['id'=>$audition->id,'object'=>'AuditionScore','field'=>'acting_comment'], key(rand() * $audition->id))</x-nymt.table.cell>
                        <x-nymt.table.cell> @livewire('component.edit-field',['id'=>$audition->id,'object'=>'AuditionScore','field'=>'singing_score', 'input' => 'score'], key(rand() * $audition->id))</x-nymt.table.cell>
                        <x-nymt.table.cell> @livewire('component.edit-field',['id'=>$audition->id,'object'=>'AuditionScore','field'=>'singing_comment'], key(rand() * $audition->id))</x-nymt.table.cell>
                        <x-nymt.table.cell> @livewire('component.edit-field',['id'=>$audition->id,'object'=>'AuditionScore','field'=>'dancing_score', 'input' => 'score'], key(rand() * $audition->id))</x-nymt.table.cell>
                        <x-nymt.table.cell> @livewire('component.edit-field',['id'=>$audition->id,'object'=>'AuditionScore','field'=>'dancing_comment'], key(rand() * $audition->id))</x-nymt.table.cell>
                        <x-nymt.table.cell> @livewire('component.edit-field',['id'=>$audition->id,'object'=>'AuditionScore','field'=>'outcome', 'input' => 'outcome'], key(rand() * $audition->id))</x-nymt.table.cell>
                            @endforeach    
                    </x-nymt.table.row>
                </x-slot>

                </x-nymt.table>
                
                <br>
                
<x-nymt.input.textarea label="Pronunciation" wire:model="form.pastoral_comment" rows="1" placeholder="e.g. 'EE-vuh' or 'AY-vuh'"></x-nymt.input.textarea>
            
            
            </x-nymt.tabs.section>  
        </x-slot>
    </x-nymt.tabs>
    </div>
    <div>
        <img src="/media/auditionee/{{ $form->auditionee->profile_photo_path }}" width="200">
        
        
        <div class="grid grid-cols-2 gap-2 mt-2">
            @if ($form->auditionee->audition->previous()) 
            <div class="text-left flex">
            <button
                class="group"
                type="button"
                wire:click="edit({{ $form->auditionee->audition->previous()->auditionee_id }})" 
                wire:confirm="Are you sure you want to leave?"
                title="Previous" alt="Previous"
            ><x-nymt.icon.chevron-left /></button>
            <button
                class="group text-sm"
                type="button"
                wire:click="edit({{ $form->auditionee->audition->previous()->auditionee_id }})" 
                wire:confirm="Are you sure you want to leave?"
                title="Previous" alt="Previous"
            >Previous</button>
            </div>
            @endif
            @if ($form->auditionee->audition->next()) 
            <div class="text-right flex">
            <button
                class="group text-sm"
                type="button"
                wire:click="edit({{ $form->auditionee->audition->next()->auditionee_id }})" 
                wire:confirm="Are you sure you want to leave?"
                title="Next" alt="Next"
            >Next</button>
            <button
                class="group"
                type="button"
                wire:click="edit({{ $form->auditionee->audition->next()->auditionee_id }})" 
                wire:confirm="Are you sure you want to leave?"
                title="Next" alt="Next"
            ><x-nymt.icon.chevron-right /></button>
            </div>
            @endif
            
    </div>
        
    </div>      
            
    @endif
            

    </div>
    
    
    </x-nymt.body>