<x-slot name="header">
    <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
    <div>
    <x-nymt.html.title>
        Manage Comment Categories
    </x-nymt.html.title>
    </div>
    <div class="md:text-right">
    
    </div>
</div>



</x-slot>


    <x-nymt.body>

            
        <div class="flex">
          <div class="flex-none">
            <x-nymt.button.primarylink wire:click="create()">Create New Category</x-nymt.button.primarylink>
            
          </div>
            
	                    
          <div class="flex-1">
            <input wire:model.live="inputsearch"  class="shadow appearance-none border rounded w-full py-2 px-3 my-3 ml-2 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" type="text" placeholder="Live Search on Name or Type..."/>
          </div>
          <div class="flex-0">
              <div class="m-1 text-right">
                  <x-nymt.input.text leadingAddOn="Rows Per Page" placeholder="Enter Number of rows per page" wire:model.live.debounce.500ms="perPage" />
              </div>
          </div>
            
          </div>
          <div class="flex-1">
          <div class="flex-none">
              <div class="m-1 text-right">
            {{ $mycategories->onEachSide(0)->links() }}
              </div>
          </div>
          </div>
                
                
                
            @if($isOpen)

            <x-nymt.modal.main maxWidth="sm">
            <x-slot name="content">

            <form>

              <div class="mb-4">
                  
                  
                  <x-nymt.input.select label="Type" model="type">
                      
                    <option value="" selected>Choose Type</option>
                    <x-nymt.options.comment-group></x-nymt.options.comment-group>
                  </x-nymt.input.select>
                        
                  <x-nymt.input.text leadingAddOn="Category" placeholder="Enter Comment Category" wire:model.defer="name" />
                  @error('name')
                  <x-nymt.input.error>{{ name }}</x-nymt.input.error>
                  @enderror
                  <x-nymt.input.text leadingAddOn="Rank" wire:model.defer="rank" />
                  @error('rank')
                  <x-nymt.input.error>{{ rank }}</x-nymt.input.error>
                  @enderror
              </div>

            </form>
  
            </x-slot>
            <x-slot name="footer">
                            <x-nymt.dialog.close-button>
                                <button type="button" class="text-center rounded-xl bg-slate-300 text-slate-800 px-6 py-2 font-semibold"  wire:click="closeModal()">Cancel</button>
                            </x-nymt.dialog.close-button>
                            <button  wire:click="store()" class="text-center rounded-xl bg-green-700 text-white px-6 py-2 font-semibold disabled:cursor-not-allowed disabled:opacity-50">Save</button>
            </x-slot>
        </x-nymt.modal.main>


            @endif

            <x-nymt.table>

                <x-slot name="head">
                
                        <x-nymt.table.heading>Type</x-nymt.table.heading>
                        <x-nymt.table.heading>Name</x-nymt.table.heading>
                        <x-nymt.table.heading>Rank</x-nymt.table.heading>
                        <x-nymt.table.heading class="w-32">Action</x-nymt.table.heading>

                </x-slot>

                <x-slot name="body">

                    @foreach($mycategories as $category)

                    <x-nymt.table.row>


                        <x-nymt.table.cell>{{ ucwords($category->type) }}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{ $category->name }}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{ $category->rank }}</x-nymt.table.cell>

                       
                        <x-nymt.table.cell>
                        <x-nymt.icon.group>
                        <a class="group flex" wire:click="edit({{ $category->id }})" title="edit" alt="edit"><x-nymt.icon.edit /></a>
                        <a class="group flex" wire:click="delete({{ $category->id }})" title="Delete" alt="Delete"><x-nymt.icon.bin /></a>
                        </x-nymt.icon.group>
                        </x-nymt.table.cell>
                    </x-nymt.table.row>

                    @endforeach

                </x-slot>

            </x-nymt.table>
    </x-nymt.body>