<div>
            <x-nymt.table>
                <x-slot name="head">
                    
                        <x-nymt.table.heading>Name</x-nymt.table.heading>
                        <x-nymt.table.heading>Start Date</x-nymt.table.heading>
                        <x-nymt.table.heading>Venue</x-nymt.table.heading>
                        <x-nymt.table.heading class="text-center">Capacity</x-nymt.table.heading>
                        <x-nymt.table.heading class="text-center">Auditions</x-nymt.table.heading>
                        @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'read'))
                        <x-nymt.table.heading class="text-center">View Actors</x-nymt.table.heading>
                        @endif
                      {{-- Only show the download icon if the user has the 'create' permission --}}
                            @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'create'))
                        <x-nymt.table.heading class="text-center">CSV</x-nymt.table.heading>
                            @endif
                </x-slot>

                <x-slot name="body">

                    @foreach($myvenuedates as $venuedate)
                    
                    <x-nymt.table.row>

                        <x-nymt.table.cell>{{ $venuedate->name }}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{ date('j M Y' , strtotime($venuedate->start_date)) }}</x-nymt.table.cell>
                        <x-nymt.table.cell>@if ($venuedate->venue)
                                {{ $venuedate->venue->name }}
                                @endif
                                </x-nymt.table.cell>
                        <x-nymt.table.cell class="text-center">{{ $venuedate->capacity }}</x-nymt.table.cell>
                        <x-nymt.table.cell class="text-center">{{ count($venuedate->auditions) }}</x-nymt.table.cell>
                        @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'read'))
                        <x-nymt.table.cell class="text-center"> 
                        <button
                            class="group text-center"
                            type="button"
                            wire:click="auditionlist({{ $venuedate->id }})" 
                            ><x-nymt.icon.eye /></button> </x-nymt.table.cell>
                        @endif
                        {{-- Only show the download icon if the user has the 'create' permission --}}
                            @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'create'))
                        <x-nymt.table.cell class="text-center">
                           <a href="/export-csv/auditionees/{{ $venuedate->id }}" target="_blank" class="text-center"><x-nymt.icon.download /></a>
                        </x-nymt.table.cell>
                            @endif
                    </x-nymt.table.row>

                    @endforeach

                </x-slot>

            </x-nymt.table>
</div>