<div>
            <x-nymt.table>
                <x-slot name="head">
                    
                        <x-nymt.table.heading>Name</x-nymt.table.heading>
                        <x-nymt.table.heading>Start Date</x-nymt.table.heading>
                        <x-nymt.table.heading>Location</x-nymt.table.heading>
                        <x-nymt.table.heading class="text-center">Capacity</x-nymt.table.heading>
                        <x-nymt.table.heading class="text-center">Attendees</x-nymt.table.heading>
                        @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'read'))
                        <x-nymt.table.heading class="text-center">View YCMs</x-nymt.table.heading>
                        @endif
                        @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'create'))
                        <x-nymt.table.heading class="text-center">CSV</x-nymt.table.heading>
                        @endif

                </x-slot>

                <x-slot name="body">

                    @foreach($mycourses as $course)
                    
                    <x-nymt.table.row>

                        <x-nymt.table.cell>{{ $course->name }}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{ date('j M Y' , strtotime($course->start_date)) }}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{ $course->location }}</x-nymt.table.cell>
                        <x-nymt.table.cell class="text-center">{{ $course->capacity }}</x-nymt.table.cell>
                        <x-nymt.table.cell class="text-center">{{ count($course->attendees) }}</x-nymt.table.cell>
                        <x-nymt.table.cell class="text-center"> 
                        <button
                            class="group text-center"
                            type="button"
                            wire:click="course({{ $course->id }})" 
                            ><x-nymt.icon.eye /></button> </x-nymt.table.cell>
                            @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'pastoral'))
                        <x-nymt.table.cell class="text-center">
                           <a href="/export-csv/course/{{ $course->id }}" target="_blank" class="text-center"><x-nymt.icon.download /></a>
                        </x-nymt.table.cell>
                        @endif
                    </x-nymt.table.row>

                    @endforeach

                </x-slot>

            </x-nymt.table>
</div>