<x-slot name="header">
    <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
        <div>
            <x-nymt.html.title>
                Auditionee Guardians
            </x-nymt.html.title>
        </div>
    </div>
</x-slot>

<x-nymt.body>
    <div class="flex mb-4">
        <div class="flex-1">
            <input wire:model.live="search"
                class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline"
                type="text" placeholder="Search guardians by name" />
        </div>
        <div class="ml-4">
            <x-nymt.input.text leadingAddOn="Rows" placeholder="Rows per page" wire:model.live="perPage" />
        </div>
    </div>

    <div class="text-right mb-2">
        {{ $guardians->onEachSide(0)->links() }}
    </div>

    <x-nymt.table>
        <x-slot name="head">
            <x-nymt.table.heading>Firstname</x-nymt.table.heading>
            <x-nymt.table.heading>Lastname</x-nymt.table.heading>
            <x-nymt.table.heading>Auditionees</x-nymt.table.heading>
            <x-nymt.table.heading>What other info would be helpful here?</x-nymt.table.heading>
        </x-slot>

        <x-slot name="body">
            @forelse($guardians as $guardian)
                <x-nymt.table.row>
                    <x-nymt.table.cell>{{ $guardian->firstname }}</x-nymt.table.cell>
                    <x-nymt.table.cell>{{ $guardian->lastname }}</x-nymt.table.cell>
                    <x-nymt.table.cell colspan="2">
                        <ul class="list-disc list-inside">
                            @foreach($guardian->auditionees as $auditionee)
                                <li>
                                    <a href="/auditionees/edit/{{ $auditionee->id }}" class="text-blue-600 hover:underline">
                                        {{ $auditionee->firstname }} {{ $auditionee->lastname }}
                                    </a>
                                    Latest Audition: {{ optional($auditionee->audition?->venue_date)->start_date?->format('d M Y') ?? 'None' }}
                                    | Latest Course: {{ optional($auditionee->course?->course)->start_date?->format('d M Y') ?? 'None' }}
                                </li>
                            @endforeach
                        </ul>
                    </x-nymt.table.cell>
                </x-nymt.table.row>
            @empty
                <x-nymt.table.row>
                    <x-nymt.table.cell colspan="3">
                        No guardians found.
                    </x-nymt.table.cell>
                </x-nymt.table.row>
            @endforelse
        </x-slot>
    </x-nymt.table>
</x-nymt.body>
