  <x-slot name="header">
    <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
    <div>
    <x-nymt.html.title>
        {{ $this->crud }} Project
        @if ($form->name)
        - {{ $form->name }}
        @endif
    </x-nymt.html.title>
    </div>
    <div class="md:text-right">
    
    <a class="group" href="/projects/" title="View Project Grid" alt="View Project Grid">Back to Project Grid</a>
    </div>
    </x-slot>

    <x-nymt.body>

    <div>

    <form wire:submit="save" >
        
        

    <x-nymt.tabs>
        <x-slot name="head">
            <x-nymt.tabs.label>Project Details</x-nymt.label>
            @if ($form->project_id) 
            <x-nymt.tabs.label>Project Roles</x-nymt.label>
            <x-nymt.tabs.label>Project Recalls</x-nymt.label>
            @endif
        </x-slot>

        <x-slot name="body">       
    
            <x-nymt.tabs.section>    
        
                <x-nymt.input.text leadingAddOn="Name" placeholder="Enter Name" wire:model.blur="form.name"></x-nymt.input.text>
                    @error('form.name') <span class="error">{{ $message }}</span> @enderror
                

                <x-nymt.input.text leadingAddOn="Details" wire:model.blur="form.details" ></x-nymt.input.text>
                    @error('form.details') <span class="error">{{ $message }}</span> @enderror
                
                <x-nymt.input.text leadingAddOn="Cast Date" wire:model.blur="form.cast_date" type="date"></x-nymt.input.text>

                <x-nymt.input.text leadingAddOn="Start Date" wire:model.blur="form.start_date" type="date"></x-nymt.input.text>
                
                <x-nymt.input.text leadingAddOn="End Date" wire:model.blur="form.end_date" type="date"></x-nymt.input.text>
     
        
        <div class="text-center">
            <button type="submit" class="relative max-w-sm w-full bg-blue-500 py-3 px-8 rounded-lg text-white font-medium disabled:cursor-not-allowed disabled:opacity-75">
                Save

                <div wire:loading.flex class="absolute top-0 right-0 bottom-0 items-center pr-4">
                    <svg class="animate-spin h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                </div>
            </button>
        </div>
         </x-nymt.tabs.section>  
        
            @if ($form->project_id) 
            <x-nymt.tabs.section> 
            
            
            <div class="grid justify-items-end">
                <div class="">
                    <x-nymt.button.primarylink href="{{ url('/roles/create/'.$form->project_id) }}">Create Role</x-nymt.button.primarylink>
                </div>
            </div>
            <x-nymt.table draggable="true">

                <x-slot name="head">
                    
                        <x-nymt.table.heading>Name</x-nymt.table.heading>
                        <x-nymt.table.heading>Comment</x-nymt.table.heading>
                        <x-nymt.table.heading>Position</x-nymt.table.heading>
                        <x-nymt.table.heading>YCM(s) Cast</x-nymt.table.heading>
                        <x-nymt.table.heading></x-nymt.table.heading>

                </x-slot>

                <x-slot name="body">
                    @foreach($form->project->roles as $role)
                    <x-nymt.table.row x-sort:item="{{ $role->id }}">
                        <x-nymt.table.cell>@livewire('component.edit-field',['id'=>$role->id,'object'=>'Role','field'=>'name'], key(rand() * $role->id))</x-nymt.table.cell>
                        <x-nymt.table.cell>@livewire('component.edit-field',['id'=>$role->id,'object'=>'Role','field'=>'comment'], key(rand() * $role->id))</x-nymt.table.cell>
                        <x-nymt.table.cell>@livewire('component.edit-field',['id'=>$role->id,'object'=>'Role','field'=>'position'], key(rand() * $role->id))</x-nymt.table.cell>
                        <x-nymt.table.cell>
                            
                        @if (($role->audition_role) && ($role->audition_role->auditionee))
                            
                            @switch($role->audition_role->status)
                                @case(2)
                                    Accepted
                                @break
                                @case(0)
                                    Declined
                                @break
                                @default
                                    Offered
                            @endswitch  
                        {{ ucwords($role->audition_role?->auditionee?->firstname) }}
                        {{ ucwords($role->audition_role?->auditionee?->lastname) }}
                        @else
                                
                        <x-nymt.dialog class="group flex">
                            <x-nymt.dialog.open>
                                
                                
                                <b>No YCM Yet</b>
                            </x-nymt.dialog.open>
        
                            <x-nymt.dialog.panel>
                                <form wire:submit="assignRole" class="flex flex-col gap-4">
                                    <input type="hidden" name="role_id" value="{{ $role->id }}">
                                    <x-nymt.html.subtitle>Assign {{ $role->name }}</x-nymt.html.subtitle>
                                         
                                        <div x-data="{ open: false, auditionees: [] }"
                                             x-init="$watch('open', value => {
                                                 if (value) {
                                                     Livewire.hook('message.processed', () => {
                                                         auditionees = @js($availableAuditionees);
                                                     });
                                                 }
                                             })">
                                            
                                            <div class="flex rounded-md shadow-sm px-3 py-2 rounded-lg">
                                            <span class="inline-flex min-w-[120px] items-center px-3 rounded-l-md border border-r-0 border-gray-300 bg-gray-50 text-gray-500 sm:text-sm">
                                                Choose YCM
                                            </span>
                                        
                                            <input type="text"
                                                   wire:model.live="search"
                                                   @focus="open = true"
                                                   @keydown.escape="open = false"
                                                   @click.away="open = false"
                                                   placeholder="Search..."
                                                   class="flex-1 px-3 py-2 rounded-lg form-input border-gray-300 block w-full transition duration-150 ease-in-out sm:text-sm sm:leading-5 rounded-none rounded-r-md">
                                        
                                            </div>
                                            <!-- Dropdown -->
                                            <div x-show="open"
                                                 x-cloak
                                                 class="left-0 mt-1 w-full bg-white border border-gray-300 rounded-md shadow-lg z-50"
                                                 x-transition>
                                                
                                                @foreach($availableAuditionees as $availableAuditionee)
                                                    <div @click="$wire.selectAuditionee({{$availableAuditionee['id']}},{{ $role->id }}); open = false"
                                                         class="cursor-pointer px-4 py-2 hover:bg-gray-200">
                                                        <span>{{$availableAuditionee['name']}}</span>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>

                                        <input type="hidden" wire:model="chosenycm">

 
 
                                <x-nymt.dialog.footer>
                                    <x-nymt.dialog.close>
                                        <button type="button" class="text-center rounded-xl bg-slate-300 text-slate-800 px-6 py-2 font-semibold">Cancel</button>
                                    </x-nymt.dialog.close>
                                    <button type="submit" class="text-center rounded-xl bg-green-700 text-white px-6 py-2 font-semibold disabled:cursor-not-allowed disabled:opacity-50">Save</button>
                                </x-nymt.dialog.footer>
                                </form>
                            </x-nymt.dialog.panel>
                        </x-nymt.dialog>
                        @endif
                            
                            
                        </x-nymt.table.cell>
                        <x-nymt.table.cell>
                        <x-nymt.icon.group>
                            
                        <button
                            class="group flex"
                            type="button"
                            wire:click="editRole({{ $role->id }})" 
                            wire:confirm="Are you sure you want to edit this role?"
                            ><x-nymt.icon.productdetails /></button>
            
                        <button
                            class="group flex"
                            type="button"
                            wire:click="deleteRole({{ $role->id }})" 
                            wire:confirm="Are you sure you want to delete this role?"
                            title="Delete" alt="Delete"
                            ><x-nymt.icon.bin /></button>
                        </x-nymt.icon.group>
                        </x-nymt.table.cell>
                    
                    </x-nymt.table.row>
                    @endforeach
                </x-slot>

            </x-nymt.table>
            
            </x-nymt.tabs.section>
            <x-nymt.tabs.section> 
            
            
            <div class="flex">
                <div class="flex-none">
                    <x-nymt.button.primarylink href="{{ url('/recalls/create/project/'.$form->project_id) }}">Create Recall</x-nymt.button.primarylink>
                </div>
            </div>
                
            <x-nymt.table>

                <x-slot name="head">
                    
                        <x-nymt.table.heading>Auditionee</x-nymt.table.heading>
                        <x-nymt.table.heading>Choice</x-nymt.table.heading>
                        <x-nymt.table.heading>Recall Date</x-nymt.table.heading>
                        <x-nymt.table.heading></x-nymt.table.heading>

                </x-slot>

                <x-slot name="body">
                    @foreach($form->project->recalls as $recall)
                    <x-nymt.table.row>
                        <x-nymt.table.cell>{{ $recall->auditionee->name}}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{ $recall->choice}}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{  date('Y-m-d' , strtotime($recall->recall_date)) }}</x-nymt.table.cell>
                        
                        <x-nymt.table.cell>
                        <x-nymt.icon.group>
                            
                        <button
                            class="group flex"
                            type="button"
                            wire:click="editRecall({{ $recall->id }})" 
                            wire:confirm="Are you sure you want to edit this recall?"
                            ><x-nymt.icon.productdetails /></button>
            
                        <button
                            class="group flex"
                            type="button"
                            wire:click="deleteRecall({{ $role->id }})" 
                            wire:confirm="Are you sure you want to delete this recall?"
                            title="Delete" alt="Delete"
                            ><x-nymt.icon.bin /></button>
                        </x-nymt.icon.group>
                        </x-nymt.table.cell>
                    
                    </x-nymt.table.row>
                    @endforeach
                </x-slot>

            </x-nymt.table>
            
            </x-nymt.tabs.section>  
            @endif
        </x-slot>
    </x-nymt.tabs>
    </form>

</div>
    </x-nymt.body>